/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.table.column;

import com.gridnine.xtrip.client.fx.core.lib.widgets.DateTimeValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.time.LocalDateTime;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class DateTimeValueWidgetColumn<M>
extends TableWidgetColumn<M, DateTimeValueWidget> {
    private final Function<M, LocalDateTime> getter;
    private final BiConsumer<M, LocalDateTime> setter;

    public DateTimeValueWidgetColumn(Function<M, LocalDateTime> aGetter, BiConsumer<M, LocalDateTime> aSetter) {
        this.getter = aGetter;
        this.setter = aSetter;
    }

    @Override
    public void setNotEditable(Boolean value) {
        super.setNotEditable(value);
        this.applyToAllRows(widget -> widget.getViewState().setNotEditable(this.isNotEditable()));
    }

    @Override
    public DateTimeValueWidget createNode() {
        DateTimeValueWidget result = new DateTimeValueWidget(this.getOwner().getViewState().isReadonly());
        result.getViewState().setNotEditable(this.isNotEditable());
        return result;
    }

    @Override
    public void readData(M model, DateTimeValueWidget node) {
        node.valueProperty().set((Object)this.getter.apply(model));
    }

    @Override
    public void writeData(M model, DateTimeValueWidget node) {
        this.setter.accept(model, (LocalDateTime)node.valueProperty().get());
    }

    @Override
    public void setReadonly(DateTimeValueWidget node, boolean readonly) {
        node.getViewState().setReadonly(readonly);
    }

    @Override
    public void setAclNotEditable(DateTimeValueWidget node) {
        node.getViewState().setAclNotEditable(this.isAclNotEditable());
    }

    @Override
    public boolean isDataChanged(M model, DateTimeValueWidget node) {
        return !node.getViewState().isImmutable() && !MiscUtil.equals((Object)node.valueProperty().get(), (Object)this.getter.apply(model));
    }
}

