/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.table.column;

import com.gridnine.xtrip.client.fx.core.lib.widgets.DateValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.time.LocalDate;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class DateValueWidgetColumn<M>
extends TableWidgetColumn<M, DateValueWidget> {
    private final Function<M, LocalDate> getter;
    private final BiConsumer<M, LocalDate> setter;

    public DateValueWidgetColumn(Function<M, LocalDate> aGetter, BiConsumer<M, LocalDate> aSetter) {
        this.getter = aGetter;
        this.setter = aSetter;
    }

    @Override
    public void setNotEditable(Boolean value) {
        super.setNotEditable(value);
        this.applyToAllRows(widget -> widget.getViewState().setNotEditable(this.isNotEditable()));
    }

    @Override
    public DateValueWidget createNode() {
        DateValueWidget result = new DateValueWidget(this.getOwner().getViewState().isReadonly());
        result.getViewState().setNotEditable(this.isNotEditable());
        return result;
    }

    @Override
    public void readData(M model, DateValueWidget node) {
        node.valueProperty().set((Object)this.getter.apply(model));
    }

    @Override
    public void writeData(M model, DateValueWidget node) {
        this.setter.accept(model, (LocalDate)node.valueProperty().get());
    }

    @Override
    public void setReadonly(DateValueWidget node, boolean readonly) {
        node.getViewState().setReadonly(readonly);
    }

    @Override
    public void setAclNotEditable(DateValueWidget node) {
        node.getViewState().setAclNotEditable(this.isAclNotEditable());
    }

    @Override
    public boolean isDataChanged(M model, DateValueWidget node) {
        return !node.getViewState().isImmutable() && !MiscUtil.equals((Object)node.valueProperty().get(), (Object)this.getter.apply(model));
    }
}

