/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.table.column;

import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableColumnOwner;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;

public abstract class ExpandableColumn<M, V extends Node>
extends TableWidgetColumn<M, ViewHolder<V>> {
    private Consumer<V> viewConfigurator;

    public void setViewConfigurator(Consumer<V> value) {
        this.viewConfigurator = value;
        if (this.viewConfigurator != null) {
            this.applyToAllRows(widget -> this.viewConfigurator.accept(widget.getView()));
        }
    }

    @Override
    public final ViewHolder<V> createNode() {
        V view = this.createView();
        if (this.viewConfigurator != null) {
            this.viewConfigurator.accept(view);
        }
        return new ViewHolder<V>(this.getOwner(), view);
    }

    @Override
    public boolean isNotHGrowable() {
        return true;
    }

    protected abstract V createView();

    @Override
    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            @Override
            public Collection<?> getSubItems() {
                return Collections.singletonList(ExpandableColumn.this.createView());
            }

            @Override
            public String getInfo() {
                StringBuilder buf = new StringBuilder();
                buf.append(ExpandableColumn.this.getClass().getSimpleName());
                if (Boolean.TRUE.equals(ExpandableColumn.this.getNotEditable())) {
                    buf.append(" [not editable]");
                }
                if (Boolean.TRUE.equals(ExpandableColumn.this.getAclNotEditable())) {
                    buf.append(" [forbidden]");
                }
                if (ExpandableColumn.this.isHidden()) {
                    buf.append(" [hidden]");
                }
                buf.append(" [").append(ExpandableColumn.this.getId()).append(']');
                return buf.toString();
            }
        };
    }

    public static class ViewHolder<V extends Node>
    extends StackPane {
        private final V view;
        private final SimpleBooleanProperty expanded = new SimpleBooleanProperty();
        private final BooleanProperty buttonVisibility = new SimpleBooleanProperty(true);
        private final TableColumnOwner<?> owner;
        private final DoubleProperty animationProgress;
        private boolean animating;
        private boolean delayedToggle;

        ViewHolder(TableColumnOwner<?> ow, V v) {
            this.owner = ow;
            this.view = v;
            Button button = new Button();
            button.setGraphic((Node)new IconNode(StandardIconShapes.RULER_14X14, (Styleable)button, StandardIconIntentions.EXPAND_BUTTON_ACTION, (Styleable)button));
            button.getStyleClass().add((Object)"xtrip-button");
            button.visibleProperty().bind((ObservableValue)this.buttonVisibility);
            button.setOnAction(evt -> {
                if (this.animating) {
                    return;
                }
                this.expanded.set(!this.isExpanded());
            });
            this.animationProgress = new SimpleDoubleProperty(0.0);
            this.animationProgress.addListener((src, o, n) -> button.getGraphic().setRotate(-180.0 * n.doubleValue()));
            this.expanded.addListener((src, o, n) -> this.toggleExpanded());
            this.sceneProperty().addListener((src, o, n) -> {
                if (n != null && this.delayedToggle) {
                    this.delayedToggle = false;
                    this.toggleExpanded();
                }
            });
            this.getChildren().add((Object)button);
        }

        public V getView() {
            return this.view;
        }

        public BooleanProperty visibilityProperty() {
            return this.buttonVisibility;
        }

        public BooleanProperty expandedProperty() {
            return this.expanded;
        }

        public boolean isExpanded() {
            return this.expanded.get();
        }

        public void setExpanded(boolean value) {
            this.expanded.set(value);
        }

        private void toggleExpanded() {
            if (this.getScene() == null) {
                this.delayedToggle = true;
                return;
            }
            this.animating = true;
            int row = this.owner.indexOfRow((Node)this);
            Timeline animation = new Timeline();
            animation.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)500.0), new KeyValue[]{new KeyValue((WritableValue)this.animationProgress, (Object)(this.animationProgress.get() == 0.0 ? 1.0 : 0.0), Interpolator.LINEAR)}));
            animation.setOnFinished(evt -> {
                if (!this.expanded.get()) {
                    this.owner.ejectWidget(row);
                }
                this.animationProgress.set(this.expanded.get() ? 1.0 : 0.0);
                this.animating = false;
            });
            if (this.expanded.get()) {
                this.owner.injectWidget(row, (Node)this.view);
            }
            animation.play();
        }
    }
}

