/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.table.column;

import com.gridnine.xtrip.client.fx.core.lib.widgets.TimeValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.time.LocalTime;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class TimeValueWidgetColumn<M>
extends TableWidgetColumn<M, TimeValueWidget> {
    private final Function<M, LocalTime> getter;
    private final BiConsumer<M, LocalTime> setter;

    public TimeValueWidgetColumn(Function<M, LocalTime> aGetter, BiConsumer<M, LocalTime> aSetter) {
        this.getter = aGetter;
        this.setter = aSetter;
    }

    @Override
    public void setNotEditable(Boolean value) {
        super.setNotEditable(value);
        this.applyToAllRows(widget -> widget.getViewState().setNotEditable(this.isNotEditable()));
    }

    @Override
    public TimeValueWidget createNode() {
        TimeValueWidget result = new TimeValueWidget(this.getOwner().getViewState().isReadonly());
        result.getViewState().setNotEditable(this.isNotEditable());
        return result;
    }

    @Override
    public void readData(M model, TimeValueWidget node) {
        node.valueProperty().set((Object)this.getter.apply(model));
    }

    @Override
    public void writeData(M model, TimeValueWidget node) {
        this.setter.accept(model, (LocalTime)node.valueProperty().get());
    }

    @Override
    public void setReadonly(TimeValueWidget node, boolean readonly) {
        node.getViewState().setReadonly(readonly);
    }

    @Override
    public void setAclNotEditable(TimeValueWidget node) {
        node.getViewState().setAclNotEditable(this.isAclNotEditable());
    }

    @Override
    public boolean isDataChanged(M model, TimeValueWidget node) {
        return !node.getViewState().isImmutable() && !MiscUtil.equals((Object)node.valueProperty().get(), (Object)this.getter.apply(model));
    }

    @Override
    public boolean isNotHGrowable() {
        return true;
    }
}

