/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog;

import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.historical.BooleanHistoricalWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.common.model.HistoricalValue;
import com.gridnine.xtrip.common.model.HistoricalValueHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javafx.util.StringConverter;

public class BooleanHistoricalWidgetColumn<M>
extends TableWidgetColumn<M, BooleanHistoricalWidget> {
    private final Function<M, List<HistoricalValue<Boolean>>> getter;
    private StringConverter<Boolean> converter = new StringConverter<Boolean>(){

        public String toString(Boolean object) {
            if (object == null) {
                return BooleanHistoricalWidgetColumn.this.getOwner().getViewState().isImmutable() ? "\u2014" : UiUtil.NULL_TEXT;
            }
            return (String)StandardRenderers.BOOLEAN.apply(object);
        }

        public Boolean fromString(String string) {
            return null;
        }
    };

    public BooleanHistoricalWidgetColumn(Function<M, List<HistoricalValue<Boolean>>> aGetter) {
        this.getter = aGetter;
    }

    public void setConverter(StringConverter<Boolean> value) {
        this.converter = Objects.requireNonNull(value);
        this.applyToAllRows(widget -> widget.setConverter(this.converter));
    }

    @Override
    public void setNotEditable(Boolean value) {
        super.setNotEditable(value);
        this.applyToAllRows(widget -> widget.getViewState().setNotEditable(this.isNotEditable()));
    }

    @Override
    public BooleanHistoricalWidget createNode() {
        BooleanHistoricalWidget result = new BooleanHistoricalWidget(this.getOwner().getViewState().isReadonly());
        result.setFieldName(this.getFieldName());
        result.getViewState().setNotEditable(this.isNotEditable());
        result.setConverter(this.converter);
        return result;
    }

    @Override
    public void readData(M model, BooleanHistoricalWidget node) {
        node.getValues().setAll((Collection)this.getter.apply(model));
    }

    @Override
    public void writeData(M model, BooleanHistoricalWidget node) {
        List<HistoricalValue<Boolean>> list = this.getter.apply(model);
        list.clear();
        list.addAll((Collection<HistoricalValue<Boolean>>)node.getValues());
    }

    @Override
    public void setReadonly(BooleanHistoricalWidget node, boolean readonly) {
        node.getViewState().setReadonly(readonly);
    }

    @Override
    public void setAclNotEditable(BooleanHistoricalWidget node) {
        node.getViewState().setAclNotEditable(this.isAclNotEditable());
    }

    @Override
    public boolean isDataChanged(M model, BooleanHistoricalWidget node) {
        return !node.getViewState().isImmutable() && !MiscUtil.equals((Object)HistoricalValueHelper.getValue((List)node.getValues()), (Object)HistoricalValueHelper.getValue(this.getter.apply(model)));
    }
}

