/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog;

import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.DictBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.common.fx.rpc.DictItem;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class DictBoxWidgetColumn<M, D extends BaseDictionary>
extends TableWidgetColumn<M, DictBoxWidget<D>> {
    protected final Class<D> dictType;
    private final Function<M, DictionaryReference<D>> getter;
    private final BiConsumer<M, DictionaryReference<D>> setter;
    private Supplier<List<DictionaryReference<D>>> itemsSupplier;
    private Supplier<DictListParameters> listParametersSupplier;
    private DictBoxWidget.DictMultiSupplier<? extends D> listParametersMultiSupplier;
    private Function<DictItem<D>, DictionaryReference<D>> valueBuilder;
    private boolean itemsSupplierAsync;

    public DictBoxWidgetColumn(Class<D> cls, Function<M, DictionaryReference<D>> aGetter, BiConsumer<M, DictionaryReference<D>> aSetter) {
        this.dictType = cls;
        this.getter = aGetter;
        this.setter = aSetter;
    }

    public Class<D> getDictType() {
        return this.dictType;
    }

    public void setItemsSupplier(Supplier<List<DictionaryReference<D>>> supplier, boolean async) {
        this.itemsSupplier = supplier;
        this.itemsSupplierAsync = async;
        this.applyToAllRows(widget -> widget.setItemsSupplier(this.itemsSupplier, this.itemsSupplierAsync));
    }

    public void setListParametersSupplier(Supplier<DictListParameters> value) {
        this.listParametersSupplier = value;
        this.applyToAllRows(widget -> widget.setListParametersSupplier(this.listParametersSupplier));
    }

    public void setListParametersSupplier(DictBoxWidget.DictMultiSupplier<? extends D> value) {
        this.listParametersMultiSupplier = value;
        this.applyToAllRows(widget -> widget.setListParametersSupplier(this.listParametersMultiSupplier));
    }

    public void setValueBuilder(Function<DictItem<D>, DictionaryReference<D>> value) {
        this.valueBuilder = value;
        this.applyToAllRows(widget -> widget.setValueBuilder(this.valueBuilder));
    }

    @Override
    public void setNotEditable(Boolean value) {
        super.setNotEditable(value);
        this.applyToAllRows(widget -> widget.getViewState().setNotEditable(this.isNotEditable()));
    }

    public void setLive(boolean value) {
        this.applyToAllRows(widget -> widget.setLive(value));
    }

    @Override
    public DictBoxWidget<D> createNode() {
        DictBoxWidget<D> result = new DictBoxWidget<D>(this.dictType, this.getOwner().getViewState().isReadonly());
        result.setFieldName(this.getFieldName());
        result.getViewState().setNotEditable(this.isNotEditable());
        result.setMaxWidth(Double.MAX_VALUE);
        if (this.itemsSupplier != null) {
            result.setItemsSupplier(this.itemsSupplier, this.itemsSupplierAsync);
        }
        if (this.listParametersSupplier != null) {
            result.setListParametersSupplier(this.listParametersSupplier);
        }
        if (this.listParametersMultiSupplier != null) {
            result.setListParametersSupplier(this.listParametersMultiSupplier);
        }
        if (this.valueBuilder != null) {
            result.setValueBuilder(this.valueBuilder);
        }
        return result;
    }

    @Override
    public void readData(M model, DictBoxWidget<D> node) {
        node.valueProperty().set(this.getter.apply(model));
    }

    @Override
    public void writeData(M model, DictBoxWidget<D> node) {
        this.setter.accept(model, (DictionaryReference<D>)node.valueProperty().get());
    }

    @Override
    public void setReadonly(DictBoxWidget<D> node, boolean readonly) {
        node.getViewState().setReadonly(readonly);
    }

    @Override
    public void setAclNotEditable(DictBoxWidget<D> node) {
        node.getViewState().setAclNotEditable(this.isAclNotEditable());
    }

    @Override
    public boolean isDataChanged(M model, DictBoxWidget<D> node) {
        return !node.getViewState().isImmutable() && !MiscUtil.equals((Object)node.valueProperty().get(), this.getter.apply(model));
    }

    @Override
    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            @Override
            public Collection<?> getSubItems() {
                return Collections.emptyList();
            }

            @Override
            public String getInfo() {
                StringBuilder buf = new StringBuilder();
                buf.append(DictBoxWidgetColumn.this.getClass().getSimpleName());
                if (Boolean.TRUE.equals(DictBoxWidgetColumn.this.getNotEditable())) {
                    buf.append(" [not editable]");
                }
                if (Boolean.TRUE.equals(DictBoxWidgetColumn.this.getAclNotEditable())) {
                    buf.append(" [forbidden]");
                }
                if (DictBoxWidgetColumn.this.isHidden()) {
                    buf.append(" [hidden]");
                }
                buf.append(" [").append(DictBoxWidgetColumn.this.dictType.getName()).append("]");
                buf.append(" [").append(DictBoxWidgetColumn.this.getId()).append(']');
                return buf.toString();
            }
        };
    }
}

