/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog;

import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.util.MultiSupplier;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class EntityBoxWidgetColumn<M, E extends BaseEntity>
extends TableWidgetColumn<M, EntityBoxWidget<E>> {
    protected final Class<E> entityType;
    private final Function<M, EntityReference<E>> getter;
    private final BiConsumer<M, EntityReference<E>> setter;
    private Supplier<List<EntityReference<E>>> itemsSupplier;
    private Supplier<IndexListParameters<E, ?>> listParametersSupplier;
    private MultiSupplier<IndexListParameters<E, ?>> listParametersMultiSupplier;
    private boolean itemsSupplierAsync;

    public EntityBoxWidgetColumn(Class<E> cls, Function<M, EntityReference<E>> aGetter, BiConsumer<M, EntityReference<E>> aSetter) {
        this.entityType = cls;
        this.getter = aGetter;
        this.setter = aSetter;
    }

    public void setItemsSupplier(Supplier<List<EntityReference<E>>> supplier, boolean async) {
        this.itemsSupplier = supplier;
        this.itemsSupplierAsync = async;
        this.applyToAllRows(widget -> widget.setItemsSupplier(this.itemsSupplier, this.itemsSupplierAsync));
    }

    public <I extends EntityIndex<E>> void setListParametersSupplier(Supplier<IndexListParameters<E, I>> value) {
        this.listParametersSupplier = value;
        this.applyToAllRows(widget -> widget.setListParametersSupplier(this.listParametersSupplier));
    }

    public void setListParametersSupplier(MultiSupplier<IndexListParameters<E, ?>> value) {
        this.listParametersMultiSupplier = value;
        this.applyToAllRows(widget -> widget.setListParametersSupplier(this.listParametersMultiSupplier));
    }

    @Override
    public void setNotEditable(Boolean value) {
        super.setNotEditable(value);
        this.applyToAllRows(widget -> widget.getViewState().setNotEditable(this.isNotEditable()));
    }

    @Override
    public EntityBoxWidget<E> createNode() {
        EntityBoxWidget<E> result = new EntityBoxWidget<E>(this.entityType, this.getOwner().getViewState().isReadonly());
        result.setFieldName(this.getFieldName());
        result.getViewState().setNotEditable(this.isNotEditable());
        result.setMaxWidth(Double.MAX_VALUE);
        if (this.itemsSupplier != null) {
            result.setItemsSupplier(this.itemsSupplier, this.itemsSupplierAsync);
        }
        if (this.listParametersSupplier != null) {
            result.setListParametersSupplier(this.listParametersSupplier);
        }
        if (this.listParametersMultiSupplier != null) {
            result.setListParametersSupplier(this.listParametersMultiSupplier);
        }
        return result;
    }

    @Override
    public void readData(M model, EntityBoxWidget<E> node) {
        node.valueProperty().set(this.getter.apply(model));
    }

    @Override
    public void writeData(M model, EntityBoxWidget<E> node) {
        this.setter.accept(model, (EntityReference<E>)node.valueProperty().get());
    }

    @Override
    public void setReadonly(EntityBoxWidget<E> node, boolean readonly) {
        node.getViewState().setReadonly(readonly);
    }

    @Override
    public void setAclNotEditable(EntityBoxWidget<E> node) {
        node.getViewState().setAclNotEditable(this.isAclNotEditable());
    }

    @Override
    public boolean isDataChanged(M model, EntityBoxWidget<E> node) {
        return !node.getViewState().isImmutable() && !MiscUtil.equals((Object)node.valueProperty().get(), this.getter.apply(model));
    }

    @Override
    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            @Override
            public Collection<?> getSubItems() {
                return Collections.emptyList();
            }

            @Override
            public String getInfo() {
                StringBuilder buf = new StringBuilder();
                buf.append(EntityBoxWidgetColumn.this.getClass().getSimpleName());
                if (Boolean.TRUE.equals(EntityBoxWidgetColumn.this.getNotEditable())) {
                    buf.append(" [not editable]");
                }
                if (Boolean.TRUE.equals(EntityBoxWidgetColumn.this.getAclNotEditable())) {
                    buf.append(" [forbidden]");
                }
                if (EntityBoxWidgetColumn.this.isHidden()) {
                    buf.append(" [hidden]");
                }
                buf.append(" [").append(EntityBoxWidgetColumn.this.entityType.getName()).append("]");
                buf.append(" [").append(EntityBoxWidgetColumn.this.getId()).append(']');
                return buf.toString();
            }
        };
    }
}

