/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog;

import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.MultiLingualWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class MultiLingualWidgetColumn<M>
extends TableWidgetColumn<M, MultiLingualWidget> {
    private final Function<M, L10nString> getter;
    private final BiConsumer<M, L10nString> setter;

    public MultiLingualWidgetColumn(Function<M, L10nString> aGetter, BiConsumer<M, L10nString> aSetter) {
        this.getter = aGetter;
        this.setter = aSetter;
    }

    @Override
    public void setNotEditable(Boolean value) {
        super.setNotEditable(value);
        this.applyToAllRows(widget -> widget.getViewState().setNotEditable(this.isNotEditable()));
    }

    @Override
    public MultiLingualWidget createNode() {
        MultiLingualWidget result = new MultiLingualWidget(this.getOwner().getViewState().isReadonly());
        result.setFieldName(this.getFieldName());
        result.getViewState().setNotEditable(this.isNotEditable());
        result.setMinWidth(Double.NEGATIVE_INFINITY);
        result.setMaxWidth(Double.MAX_VALUE);
        return result;
    }

    @Override
    public void readData(M model, MultiLingualWidget node) {
        node.valueProperty().set((Object)this.getter.apply(model));
    }

    @Override
    public void writeData(M model, MultiLingualWidget node) {
        this.setter.accept(model, (L10nString)node.valueProperty().get());
    }

    @Override
    public void setReadonly(MultiLingualWidget node, boolean readonly) {
        node.getViewState().setReadonly(readonly);
    }

    @Override
    public void setAclNotEditable(MultiLingualWidget node) {
        node.getViewState().setAclNotEditable(this.isAclNotEditable());
    }

    @Override
    public boolean isDataChanged(M model, MultiLingualWidget node) {
        return !node.getViewState().isImmutable() && !MiscUtil.equals((Object)node.valueProperty().get(), (Object)this.getter.apply(model));
    }
}

