/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog;

import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.NestedEntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.util.MultiSupplier;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class NestedEntityBoxWidgetColumn<M, R extends BaseEntity, N extends BaseEntity>
extends TableWidgetColumn<M, NestedEntityBoxWidget<R, N>> {
    private final Class<R> rootEntityType;
    private final Class<N> nestedEntityType;
    private final Function<M, NestedEntityReference<R, N>> getter;
    private final BiConsumer<M, NestedEntityReference<R, N>> setter;
    private Supplier<List<NestedEntityReference<R, N>>> itemsSupplier;
    private Supplier<IndexListParameters<R, ?>> listParametersSupplier;
    private MultiSupplier<IndexListParameters<R, ?>> listParametersMultiSupplier;
    private Function<EntityIndex<R>, NestedEntityReference<R, N>> nestedReferenceBuilder;
    private boolean itemsSupplierAsync;
    private boolean live;

    public NestedEntityBoxWidgetColumn(Class<R> rCls, Class<N> nCls, Function<M, NestedEntityReference<R, N>> aGetter, BiConsumer<M, NestedEntityReference<R, N>> aSetter) {
        this.rootEntityType = rCls;
        this.nestedEntityType = nCls;
        this.getter = aGetter;
        this.setter = aSetter;
    }

    public void setItemsSupplier(Supplier<List<NestedEntityReference<R, N>>> supplier, boolean async) {
        this.itemsSupplier = supplier;
        this.itemsSupplierAsync = async;
        this.applyToAllRows(widget -> widget.setItemsSupplier(this.itemsSupplier, this.itemsSupplierAsync));
    }

    public <I extends EntityIndex<R>> void setListParametersSupplier(Supplier<IndexListParameters<R, I>> value) {
        this.listParametersSupplier = value;
        this.applyToAllRows(widget -> widget.setListParametersSupplier(this.listParametersSupplier));
    }

    public void setListParametersMultiSupplier(MultiSupplier<IndexListParameters<R, ?>> value) {
        this.listParametersMultiSupplier = value;
        this.applyToAllRows(widget -> widget.setListParametersSupplier(this.listParametersMultiSupplier));
    }

    public void setNestedReferenceBuilder(Function<EntityIndex<R>, NestedEntityReference<R, N>> value) {
        this.nestedReferenceBuilder = Objects.requireNonNull(value);
        this.applyToAllRows(widget -> widget.setNestedReferenceBuilder(this.nestedReferenceBuilder));
    }

    @Override
    public void setNotEditable(Boolean value) {
        super.setNotEditable(value);
        this.applyToAllRows(widget -> widget.getViewState().setNotEditable(this.isNotEditable()));
    }

    public void setLive(boolean value) {
        this.live = value;
        this.applyToAllRows(widget -> widget.setLive(this.live));
    }

    @Override
    public NestedEntityBoxWidget<R, N> createNode() {
        NestedEntityBoxWidget<R, N> result = new NestedEntityBoxWidget<R, N>(this.rootEntityType, this.nestedEntityType, this.getOwner().getViewState().isReadonly());
        result.setFieldName(this.getFieldName());
        result.getViewState().setNotEditable(this.isNotEditable());
        result.setMinWidth(Double.NEGATIVE_INFINITY);
        result.setMaxWidth(Double.MAX_VALUE);
        result.setLive(this.live);
        if (this.itemsSupplier != null) {
            result.setItemsSupplier(this.itemsSupplier, this.itemsSupplierAsync);
        }
        if (this.listParametersSupplier != null) {
            result.setListParametersSupplier(this.listParametersSupplier);
        }
        if (this.listParametersMultiSupplier != null) {
            result.setListParametersSupplier(this.listParametersMultiSupplier);
        }
        if (this.nestedReferenceBuilder != null) {
            result.setNestedReferenceBuilder(this.nestedReferenceBuilder);
        }
        return result;
    }

    @Override
    public void readData(M model, NestedEntityBoxWidget<R, N> node) {
        node.valueProperty().set(this.getter.apply(model));
    }

    @Override
    public void writeData(M model, NestedEntityBoxWidget<R, N> node) {
        this.setter.accept(model, (NestedEntityReference<R, N>)node.valueProperty().get());
    }

    @Override
    public void setReadonly(NestedEntityBoxWidget<R, N> node, boolean readonly) {
        node.getViewState().setReadonly(readonly);
    }

    @Override
    public void setAclNotEditable(NestedEntityBoxWidget<R, N> node) {
        node.getViewState().setAclNotEditable(this.isAclNotEditable());
    }

    @Override
    public boolean isDataChanged(M model, NestedEntityBoxWidget<R, N> node) {
        return !node.getViewState().isImmutable() && !MiscUtil.equals((Object)node.valueProperty().get(), this.getter.apply(model));
    }

    @Override
    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            @Override
            public Collection<?> getSubItems() {
                return Collections.emptyList();
            }

            @Override
            public String getInfo() {
                StringBuilder buf = new StringBuilder();
                buf.append(NestedEntityBoxWidgetColumn.this.getClass().getSimpleName());
                if (Boolean.TRUE.equals(NestedEntityBoxWidgetColumn.this.getNotEditable())) {
                    buf.append(" [not editable]");
                }
                if (Boolean.TRUE.equals(NestedEntityBoxWidgetColumn.this.getAclNotEditable())) {
                    buf.append(" [forbidden]");
                }
                if (NestedEntityBoxWidgetColumn.this.isHidden()) {
                    buf.append(" [hidden]");
                }
                buf.append(" [").append(NestedEntityBoxWidgetColumn.this.rootEntityType.getName()).append("]");
                buf.append(" [").append(NestedEntityBoxWidgetColumn.this.nestedEntityType.getName()).append("]");
                buf.append(" [").append(NestedEntityBoxWidgetColumn.this.getId()).append(']');
                return buf.toString();
            }
        };
    }
}

