/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog;

import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.PopupWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.scene.Node;

public class PopupWidgetColumn<M, I, V extends Node>
extends TableWidgetColumn<M, PopupWidget<V>> {
    private final Function<M, I> getter;
    final Supplier<ViewController<V, I>> controllerSupplier;
    private String actionText;
    private String infoText;
    private Consumer<Dialog> dialogConfigurator;
    private Runnable dialogCloseHandler;

    public PopupWidgetColumn(Function<M, I> aGgetter, Supplier<ViewController<V, I>> cs) {
        this.getter = aGgetter;
        this.controllerSupplier = cs;
    }

    public void setActionText(String value) {
        this.actionText = value;
        this.applyToAllRows(widget -> widget.setActionText(this.actionText));
    }

    public void setInfoText(String value) {
        this.infoText = value;
        this.applyToAllRows(widget -> widget.setInfoText(this.infoText));
    }

    public void setDialogConfigurator(Consumer<Dialog> value) {
        this.dialogConfigurator = value;
        this.applyToAllRows(widget -> widget.setDialogConfigurator(this.dialogConfigurator));
    }

    public void setDialogCloseHandler(Runnable value) {
        this.dialogCloseHandler = value;
        this.applyToAllRows(widget -> widget.setDialogCloseHandler(this.dialogCloseHandler));
    }

    @Override
    public boolean isNotHGrowable() {
        return TextUtil.isBlank((String)this.actionText) && TextUtil.isBlank((String)this.infoText);
    }

    @Override
    public PopupWidget<V> createNode() {
        ViewController<V, I> controller = this.controllerSupplier.get();
        PopupWidget result = new PopupWidget();
        result.setFieldName(this.getFieldName());
        result.setActionText(this.actionText);
        result.setInfoText(this.infoText);
        result.setDialogConfigurator(this.dialogConfigurator);
        result.setDialogCloseHandler(this.dialogCloseHandler);
        result.setView(controller.getView());
        result.getProperties().put((Object)"controller", controller);
        return result;
    }

    @Override
    public void readData(M model, PopupWidget<V> node) {
        ViewController controller = (ViewController)node.getProperties().get((Object)"controller");
        controller.readData(this.getter.apply(model));
    }

    @Override
    public void writeData(M model, PopupWidget<V> node) {
        ViewController controller = (ViewController)node.getProperties().get((Object)"controller");
        controller.writeData(this.getter.apply(model));
    }

    @Override
    public void setReadonly(PopupWidget<V> node, boolean readonly) {
        ViewController controller = (ViewController)node.getProperties().get((Object)"controller");
        controller.setReadonly(this.isNotEditable() || readonly);
    }

    @Override
    public void setAclNotEditable(PopupWidget<V> node) {
        ViewController controller = (ViewController)node.getProperties().get((Object)"controller");
        controller.setAclNotEditable(this.isAclNotEditable());
    }

    @Override
    public boolean isDataChanged(M model, PopupWidget<V> node) {
        ViewController controller = (ViewController)node.getProperties().get((Object)"controller");
        return controller.isDataChanged();
    }

    @Override
    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            @Override
            public Collection<?> getSubItems() {
                return Collections.singletonList(PopupWidgetColumn.this.controllerSupplier.get().getView());
            }

            @Override
            public String getInfo() {
                StringBuilder buf = new StringBuilder();
                buf.append(PopupWidgetColumn.this.getClass().getSimpleName());
                if (Boolean.TRUE.equals(PopupWidgetColumn.this.getNotEditable())) {
                    buf.append(" [not editable]");
                }
                if (Boolean.TRUE.equals(PopupWidgetColumn.this.getAclNotEditable())) {
                    buf.append(" [forbidden]");
                }
                if (PopupWidgetColumn.this.isHidden()) {
                    buf.append(" [hidden]");
                }
                buf.append(" [").append(PopupWidgetColumn.this.getId()).append(']');
                return buf.toString();
            }
        };
    }
}

