/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog;

import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.historical.PriceHistoricalWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.common.model.HistoricalValue;
import com.gridnine.xtrip.common.model.HistoricalValueHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public class PriceHistoricalWidgetColumn<M>
extends TableWidgetColumn<M, PriceHistoricalWidget> {
    private final Function<M, List<HistoricalValue<BigDecimal>>> getter;

    public PriceHistoricalWidgetColumn(Function<M, List<HistoricalValue<BigDecimal>>> aGetter) {
        this.getter = aGetter;
    }

    @Override
    public void setNotEditable(Boolean value) {
        super.setNotEditable(value);
        this.applyToAllRows(widget -> widget.getViewState().setNotEditable(this.isNotEditable()));
    }

    @Override
    public PriceHistoricalWidget createNode() {
        PriceHistoricalWidget result = new PriceHistoricalWidget(this.getOwner().getViewState().isReadonly());
        result.setFieldName(this.getFieldName());
        result.getViewState().setNotEditable(this.isNotEditable());
        return result;
    }

    @Override
    public void readData(M model, PriceHistoricalWidget node) {
        node.getValues().setAll((Collection)this.getter.apply(model));
    }

    @Override
    public void writeData(M model, PriceHistoricalWidget node) {
        List<HistoricalValue<BigDecimal>> list = this.getter.apply(model);
        list.clear();
        list.addAll((Collection<HistoricalValue<BigDecimal>>)node.getValues());
    }

    @Override
    public void setReadonly(PriceHistoricalWidget node, boolean readonly) {
        node.getViewState().setReadonly(readonly);
    }

    @Override
    public void setAclNotEditable(PriceHistoricalWidget node) {
        node.getViewState().setAclNotEditable(this.isAclNotEditable());
    }

    @Override
    public boolean isDataChanged(M model, PriceHistoricalWidget node) {
        return !node.getViewState().isImmutable() && !MiscUtil.equals((Object)HistoricalValueHelper.getValue((List)node.getValues()), (Object)HistoricalValueHelper.getValue(this.getter.apply(model)));
    }
}

