/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog;

import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.historical.StringHistoricalWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.common.model.HistoricalValue;
import com.gridnine.xtrip.common.model.HistoricalValueHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public class StringHistoricalWidgetColumn<M>
extends TableWidgetColumn<M, StringHistoricalWidget> {
    private final Function<M, List<HistoricalValue<String>>> getter;

    public StringHistoricalWidgetColumn(Function<M, List<HistoricalValue<String>>> aGetter) {
        this.getter = aGetter;
    }

    @Override
    public void setNotEditable(Boolean value) {
        super.setNotEditable(value);
        this.applyToAllRows(widget -> widget.getViewState().setNotEditable(this.isNotEditable()));
    }

    @Override
    public StringHistoricalWidget createNode() {
        StringHistoricalWidget result = new StringHistoricalWidget(this.getOwner().getViewState().isReadonly());
        result.setFieldName(this.getFieldName());
        result.getViewState().setNotEditable(this.isNotEditable());
        result.setMinWidth(Double.NEGATIVE_INFINITY);
        return result;
    }

    @Override
    public void readData(M model, StringHistoricalWidget node) {
        node.getValues().setAll((Collection)this.getter.apply(model));
    }

    @Override
    public void writeData(M model, StringHistoricalWidget node) {
        List<HistoricalValue<String>> list = this.getter.apply(model);
        list.clear();
        list.addAll((Collection<HistoricalValue<String>>)node.getValues());
    }

    @Override
    public void setReadonly(StringHistoricalWidget node, boolean readonly) {
        node.getViewState().setReadonly(readonly);
    }

    @Override
    public void setAclNotEditable(StringHistoricalWidget node) {
        node.getViewState().setAclNotEditable(this.isAclNotEditable());
    }

    @Override
    public boolean isDataChanged(M model, StringHistoricalWidget node) {
        return !node.getViewState().isImmutable() && !TextUtil.isSame((String)((String)HistoricalValueHelper.getValue((List)node.getValues())), (String)((String)HistoricalValueHelper.getValue(this.getter.apply(model))));
    }
}

