/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.registry.basic;

import com.gridnine.xtrip.client.fx.core.kb.KeyBindingAction;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.registry.RegistryItem;
import com.gridnine.xtrip.client.fx.core.registry.RegistryItemType;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import java.util.Comparator;
import javafx.scene.layout.Region;

public interface MainTool
extends RegistryItem<MainTool> {
    public static final RegistryItemType<MainTool> TYPE = new RegistryItemType("MAIN-TOOL");
    public static final Comparator<MainTool> COMPARATOR = (tool1, tool2) -> {
        if (tool1.getWeight() != tool2.getWeight()) {
            return tool1.getWeight() < tool2.getWeight() ? -1 : 1;
        }
        return tool1.getName().compareTo(tool2.getName());
    };

    public static MainTool forId(String id) {
        return ClientRegistry.get().allOf(TYPE).get(id);
    }

    @Override
    default public RegistryItemType<MainTool> getType() {
        return TYPE;
    }

    default public String getName() {
        String result = ClientRegistry.get().getResourceFor(this, "name");
        return result == null ? this.getId() : result;
    }

    default public boolean isAvailable() {
        return true;
    }

    default public boolean isAltTool() {
        return false;
    }

    public double getWeight();

    default public KeyBindingAction getKeyBindingAction() {
        return null;
    }

    default public void configureToolNode(Region node) {
    }

    default public String getShape() {
        return null;
    }

    public AclQuery getACLQuery();

    public void execute();
}

