/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.startup;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomTextArea;
import com.gridnine.xtrip.client.fx.core.lib.components.dialog.MessagePane;
import com.gridnine.xtrip.client.fx.core.startup.AppInitHandler;
import com.gridnine.xtrip.client.fx.core.startup.AutoUpdate;
import com.gridnine.xtrip.client.fx.core.startup.BaseStartupForm;
import com.gridnine.xtrip.client.fx.core.startup.StartupPane;
import com.gridnine.xtrip.client.fx.core.startup.UpdateHelper;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collections;
import java.util.function.Predicate;
import javafx.scene.Node;
import javafx.stage.Stage;
import org.java.plugin.boot.Application;
import org.slf4j.LoggerFactory;

final class PostUpdateProcedure {
    static void execute(Application app, StartupPane pane, Runnable onProceed) {
        ((Stage)pane.getScene().getWindow()).setTitle(Messages.General_Initialization);
        pane.setContent(Messages.General_App_initialization);
        pane.getProgressBar().setVisible(true);
        pane.getProgressBar().setProgress(-1.0);
        ErrorHandler.registerRepairHandler(error -> {
            if (PostUpdateProcedure.checkError(error, t -> t instanceof NoClassDefFoundError || t instanceof NoSuchMethodError)) {
                ErrorHandler.LOG.error(error.getMessage(), error);
                FxUtil.runInFxThread(() -> {
                    CustomTextArea detailsArea = new CustomTextArea();
                    detailsArea.setEditable(false);
                    detailsArea.setText(Messages.Repair_needed);
                    new Dialog().setTitle(Messages.General_Error_message).setBody((Node)detailsArea).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.General_Close, () -> {
                        try {
                            File localIndexFile = UpdateHelper.getLocalIndexFile();
                            if (localIndexFile.isFile()) {
                                Files.deleteIfExists(localIndexFile.toPath());
                                AutoUpdate.restart(app, Collections.singletonMap("com.gridnine.xtrip.boot.repair", "true"));
                            }
                        }
                        catch (IOException e) {
                            ErrorHandler.handle(e);
                        }
                    }).show(Dialog.getGlobalWindow());
                });
                return true;
            }
            return false;
        });
        ErrorHandler.register(error -> {
            LoggerFactory.getLogger(PostUpdateProcedure.class).error("post-update procedure failed", error);
            FxUtil.runInFxThread(() -> {
                pane.getProgressBar().setVisible(false);
                pane.setContent(new BaseStartupForm(){
                    {
                        this.setMessage((Node)MessagePane.error(ErrorHandler.getMessage(error)).setWrapText(true));
                    }
                });
            });
        });
        String handlerClassName = System.getProperty("client.fx.appInitHandler");
        if (handlerClassName != null) {
            Thread thread = new Thread(() -> {
                try {
                    AppInitHandler handler = (AppInitHandler)Class.forName(handlerClassName).newInstance();
                    handler.doInit(pane, onProceed);
                }
                catch (Exception e) {
                    ErrorHandler.handle(e);
                }
            }, "init process");
            thread.setDaemon(true);
            thread.start();
        } else {
            onProceed.run();
        }
    }

    private static boolean checkError(Throwable t, Predicate<Throwable> check) {
        return t != null && (check.test(t) || t.getCause() != t && PostUpdateProcedure.checkError(t.getCause(), check));
    }

    private PostUpdateProcedure() {
    }
}

