/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.ui;

import com.gridnine.xtrip.client.fx.core.acl.FxAclUtil;
import com.gridnine.xtrip.client.fx.core.kb.KeyBindingAction;
import com.gridnine.xtrip.client.fx.core.kb.KeyBindings;
import com.gridnine.xtrip.client.fx.core.kb.ShortcutHandler;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconCache;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.components.progressindicator.CustomProgressIndicator;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.registry.basic.MainTool;
import com.gridnine.xtrip.client.fx.core.res.FxRes;
import com.gridnine.xtrip.client.fx.core.ui.tab.TabContentWrapper;
import com.gridnine.xtrip.client.fx.core.ui.tab.TabPane;
import com.gridnine.xtrip.client.fx.core.ui.tab.TabPaneTab;
import com.gridnine.xtrip.client.fx.core.util.ClientSettings;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.geometry.HPos;
import javafx.geometry.Side;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.SVGPath;
import javafx.scene.shape.Shape;

public class HeaderPane
extends StackPane {
    private static final PseudoClass SHOWING_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"showing");
    private Pane toolsPane;
    private TabPane tabPane;
    private ContextMenu mainMenu;
    private final TabPaneTab homeTab;
    private List<MainTool> tools = Collections.emptyList();

    public HeaderPane() {
        this.getStyleClass().add((Object)"xtrip-header-pane");
        this.createGUI();
        this.createListeners();
        this.homeTab = new TabPaneTab();
        this.homeTab.setTooltip(new Tooltip(Messages.General_Home_page));
        this.homeTab.setIcon(StandardIconShapes.HOME_16X16);
        this.homeTab.setClosable(false);
        this.homeTab.setContent((Node)new StackPane(new Node[]{new CustomProgressIndicator()}));
        this.tabPane.getSpecialTabs().add((Object)this.homeTab);
    }

    private void createGUI() {
        Pane headerPane = this.createHeaderPane();
        this.getChildren().addAll((Object[])new Node[]{headerPane});
    }

    private Pane createHeaderPane() {
        this.toolsPane = this.createToolsPane();
        this.tabPane = this.createTabPane();
        GridPane pane = new GridPane();
        pane.getStyleClass().add((Object)"xtrip-header-pane");
        UiUtil.gridPosition(pane, (Node)this.toolsPane).col(0).row(0).hAlignment(HPos.LEFT).hAlignment(HPos.LEFT).hGrow(Priority.NEVER).vGrow(Priority.ALWAYS).place();
        UiUtil.gridPosition(pane, (Node)this.tabPane).col(1).row(0).hAlignment(HPos.LEFT).hAlignment(HPos.LEFT).hGrow(Priority.ALWAYS).vGrow(Priority.ALWAYS).place();
        return pane;
    }

    private Pane createToolsPane() {
        this.mainMenu = new ContextMenu(new MenuItem[]{new CustomMenuItem((Node)new CustomProgressIndicator(), false)});
        StackPane pane = new StackPane();
        pane.getStyleClass().add((Object)"tools-pane");
        UiUtil.setTooltip((Node)pane, Messages.General_Menu);
        IconNode toolsButtonIcon = new IconNode(StandardIconShapes.MENU_16X16, (Styleable)pane, StandardIconIntentions.TABS_MENU, (Styleable)pane);
        toolsButtonIcon.getStyleClass().add((Object)"button-icon");
        pane.getChildren().add((Object)toolsButtonIcon);
        return pane;
    }

    private TabPane createTabPane() {
        return new TabPane();
    }

    public void toggleMainMenu() {
        if (this.mainMenu.isShowing()) {
            this.mainMenu.hide();
        } else {
            this.mainMenu.show((Node)this.toolsPane, Side.BOTTOM, 0.0, -1.0);
        }
    }

    private void createListeners() {
        this.toolsPane.setOnMousePressed(evt -> {
            if (evt.getButton() != MouseButton.PRIMARY) {
                return;
            }
            evt.consume();
            if (this.mainMenu.isShowing()) {
                this.mainMenu.hide();
                this.mainMenu.getItems().clear();
                return;
            }
            this.populateMenu(this.mainMenu, evt.isAltDown());
            this.mainMenu.show((Node)this.toolsPane, Side.BOTTOM, 0.0, -1.0);
        });
        this.mainMenu.setOnShown(event -> this.toolsPane.pseudoClassStateChanged(SHOWING_PSEUDOCLASS_STATE, true));
        this.mainMenu.setOnHidden(event -> this.toolsPane.pseudoClassStateChanged(SHOWING_PSEUDOCLASS_STATE, false));
    }

    public void initMainTools() throws Exception {
        this.tools = ClientRegistry.get().allOf(MainTool.TYPE).values().stream().filter(tool -> tool != null).collect(Collectors.toList());
        HashMap<String, AclQuery> map = new HashMap<String, AclQuery>();
        for (MainTool tool2 : this.tools) {
            AclQuery query = tool2.getACLQuery();
            if (query == null) continue;
            map.put(tool2.getId(), query);
        }
        Set<String> grantedIds = FxAclUtil.applyACL(map);
        Iterator<MainTool> it = this.tools.iterator();
        while (it.hasNext()) {
            MainTool tool3 = it.next();
            if (!map.containsKey(tool3.getId()) || grantedIds.contains(tool3.getId())) continue;
            it.remove();
        }
        this.tools.sort(MainTool.COMPARATOR);
    }

    public void handleShortcut(KeyEvent event) {
        Node content;
        TabPaneTab tab;
        KeyBindings kb = KeyBindings.get();
        for (MainTool tool : this.tools) {
            KeyBindingAction kbAction = tool.getKeyBindingAction();
            if (kbAction == null || !kb.getKeyCombination(kbAction).match(event)) continue;
            event.consume();
            this.mainMenu.hide();
            tool.execute();
            return;
        }
        if (!event.isConsumed() && (tab = (TabPaneTab)this.tabPane.getRegularTabsSelectionModel().getSelectedItem()) != null && tab.getContent() != null && ((TabContentWrapper)tab.getContent()).getContent() != null && (content = ((TabContentWrapper)tab.getContent()).getContent()) instanceof ShortcutHandler) {
            ((ShortcutHandler)content).handleShortcut(event);
        }
        if (!event.isConsumed() && (tab = (TabPaneTab)this.tabPane.getSpecialTabsSelectionModel().getSelectedItem()) != null && tab.getContent() instanceof ShortcutHandler) {
            ((ShortcutHandler)tab.getContent()).handleShortcut(event);
        }
    }

    private void populateMenu(ContextMenu menu, boolean alt) {
        ArrayList<Object> items = new ArrayList<Object>();
        GridPane decoratedToolsPane = new GridPane();
        if (!alt) {
            this.createScaleTools(decoratedToolsPane);
        }
        int count = decoratedToolsPane.getChildren().size();
        int columns = 3;
        for (MainTool tool : this.tools) {
            if (!tool.isAvailable() || alt && !tool.isAltTool() || !alt && tool.isAltTool()) continue;
            if (tool.getShape() == null) {
                MenuItem item = new MenuItem(tool.getName());
                item.getStyleClass().add((Object)"plain-menu-item");
                item.setOnAction(event -> tool.execute());
                items.add(item);
                continue;
            }
            GridPane toolPane = new GridPane();
            toolPane.getStyleClass().add((Object)"tool-pane");
            toolPane.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
                menu.hide();
                tool.execute();
            });
            Region icon = new Region();
            SVGPath shape = new SVGPath();
            shape.setContent(tool.getShape());
            icon.setShape((Shape)shape);
            icon.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
            icon.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
            icon.getStyleClass().add((Object)"icon");
            UiUtil.gridPosition(toolPane, (Node)icon).col(0).row(0).hAlignment(HPos.CENTER).vAlignment(VPos.CENTER).hGrow(Priority.NEVER).vGrow(Priority.NEVER).place();
            Label titleLabel = new Label(tool.getName());
            titleLabel.getStyleClass().add((Object)"title-label");
            UiUtil.gridPosition(toolPane, (Node)titleLabel).col(0).row(1).hAlignment(HPos.CENTER).vAlignment(VPos.CENTER).hGrow(Priority.ALWAYS).vGrow(Priority.NEVER).place();
            UiUtil.gridPosition(decoratedToolsPane, (Node)toolPane).col(count % columns).row(count / columns).hAlignment(HPos.LEFT).vAlignment(VPos.CENTER).hGrow(Priority.ALWAYS).vGrow(Priority.ALWAYS).place();
            tool.configureToolNode((Region)toolPane);
            ++count;
        }
        if (!decoratedToolsPane.getChildren().isEmpty()) {
            CustomMenuItem decoratedMenuItem = new CustomMenuItem((Node)decoratedToolsPane);
            decoratedMenuItem.getStyleClass().add((Object)"decorated-menu-item");
            decoratedMenuItem.setHideOnClick(false);
            items.add(0, decoratedMenuItem);
        }
        menu.getItems().setAll(items);
    }

    private void createScaleTools(final GridPane ownerPane) {
        final SimpleIntegerProperty scale = new SimpleIntegerProperty(ClientSettings.get().getScaleFactor()){

            protected void invalidated() {
                ClientSettings settings = ClientSettings.get();
                settings.setScaleFactor(this.get());
                settings.save();
                FxRes.applyScaleFactor(HeaderPane.this.getScene(), this.get());
                FxRes.applyScaleFactor(ownerPane.getScene(), this.get());
                IconCache.SCALE.set(UiUtil.computeScale(ClientSettings.get().getScaleFactor()));
                ownerPane.getScene().getWindow().sizeToScene();
            }
        };
        Label label = new Label(Messages.General_Zoom_out);
        label.getStyleClass().add((Object)"title-label");
        StackPane toolPane = new StackPane(new Node[]{label});
        toolPane.getStyleClass().addAll((Object[])new String[]{"tool-pane", "scale"});
        toolPane.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> scale.set(scale.get() - 1));
        toolPane.disableProperty().bind((ObservableValue)Bindings.greaterThan((int)-4, (ObservableNumberValue)scale));
        UiUtil.gridPosition(ownerPane, (Node)toolPane).col(0).row(0).hAlignment(HPos.LEFT).vAlignment(VPos.CENTER).hGrow(Priority.ALWAYS).vGrow(Priority.ALWAYS).place();
        label = new Label();
        label.textProperty().bind((ObservableValue)new StringBinding(){
            {
                this.bind(new Observable[]{scale});
            }

            protected String computeValue() {
                return 100 + scale.get() * 10 + "%";
            }
        });
        label.getStyleClass().add((Object)"title-label");
        toolPane = new StackPane(new Node[]{label});
        toolPane.getStyleClass().addAll((Object[])new String[]{"tool-pane", "scale"});
        toolPane.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> scale.set(0));
        toolPane.disableProperty().bind((ObservableValue)Bindings.equal((int)0, (ObservableNumberValue)scale));
        UiUtil.gridPosition(ownerPane, (Node)toolPane).col(1).row(0).hAlignment(HPos.LEFT).vAlignment(VPos.CENTER).hGrow(Priority.ALWAYS).vGrow(Priority.ALWAYS).place();
        UiUtil.setTooltip((Node)toolPane, Messages.General_Zoom_original_scale);
        label = new Label(Messages.General_Zoom_in);
        label.getStyleClass().add((Object)"title-label");
        toolPane = new StackPane(new Node[]{label});
        toolPane.getStyleClass().addAll((Object[])new String[]{"tool-pane", "scale"});
        toolPane.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> scale.set(scale.get() + 1));
        toolPane.disableProperty().bind((ObservableValue)Bindings.lessThan((int)9, (ObservableNumberValue)scale));
        UiUtil.gridPosition(ownerPane, (Node)toolPane).col(2).row(0).hAlignment(HPos.LEFT).vAlignment(VPos.CENTER).hGrow(Priority.ALWAYS).vGrow(Priority.ALWAYS).place();
    }

    public TabPane getTabPane() {
        return this.tabPane;
    }

    public TabPaneTab getHomeTab() {
        return this.homeTab;
    }
}

