/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.ui;

import com.gridnine.xtrip.client.fx.core.ui.navigation.NavigationPane;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;

public class WorkspacePane
extends StackPane {
    private NavigationPane navigationPane;
    private StackPane contentPane;
    private Pane workspacePane;
    private DoubleProperty animationTransition;
    private BooleanProperty animating;

    public WorkspacePane() {
        this.getStyleClass().add((Object)"xtrip-workspace-pane");
        this.createGUI();
        this.createListeners();
    }

    private void createGUI() {
        this.navigationPane = new NavigationPane();
        this.contentPane = new StackPane();
        this.workspacePane = new StackPane(){

            protected void layoutChildren() {
                double width = this.snapSize(this.getWidth());
                double height = this.snapSize(this.getHeight());
                double animationTransitionValue = WorkspacePane.this.getAnimationTransition();
                double navigationPaneWidth = this.snapSize(WorkspacePane.this.navigationPane.prefWidth(-1.0));
                double navigationPaneHeight = height;
                double navigationPaneX = Math.round(animationTransitionValue * navigationPaneWidth);
                double navigationPaneY = 0.0;
                WorkspacePane.this.navigationPane.relocate(navigationPaneX, navigationPaneY);
                WorkspacePane.this.navigationPane.resize(navigationPaneWidth, navigationPaneHeight);
                double contentPaneX = navigationPaneX + navigationPaneWidth;
                double contentPaneY = 0.0;
                double contentPaneWidth = width - contentPaneX;
                double contentPaneHeight = height;
                WorkspacePane.this.contentPane.relocate(contentPaneX, contentPaneY);
                WorkspacePane.this.contentPane.resize(contentPaneWidth, contentPaneHeight);
            }
        };
        this.workspacePane.getStyleClass().add((Object)"xtrip-workspace-pane-container-pane");
        this.workspacePane.getChildren().addAll((Object[])new Node[]{this.navigationPane, this.contentPane});
        this.getChildren().addAll((Object[])new Node[]{this.workspacePane});
    }

    private void createListeners() {
        this.animationTransitionProperty().addListener((observable, oldValue, newValue) -> this.workspacePane.requestLayout());
    }

    public final DoubleProperty animationTransitionProperty() {
        if (this.animationTransition == null) {
            this.animationTransition = new SimpleDoubleProperty((Object)this, "animationTransition");
        }
        return this.animationTransition;
    }

    public final void setAnimationTransition(double value) {
        this.animationTransitionProperty().set(value);
    }

    public final double getAnimationTransition() {
        return this.animationTransition != null ? this.animationTransition.get() : 0.0;
    }

    public final BooleanProperty animatingProperty() {
        if (this.animating == null) {
            this.animating = new SimpleBooleanProperty((Object)this, "animating");
        }
        return this.animating;
    }

    public final void setAnimating(boolean value) {
        this.animatingProperty().set(value);
    }

    public final boolean isAnimating() {
        return this.animating != null ? this.animating.get() : false;
    }

    public NavigationPane getNavigationPane() {
        return this.navigationPane;
    }

    public StackPane getContentPane() {
        return this.contentPane;
    }
}

