/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.ui.navigation;

import com.gridnine.xtrip.client.fx.core.acl.FxAclUtil;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.factory.FactoryTool;
import com.gridnine.xtrip.client.fx.core.factory.FactoryToolCategory;
import com.gridnine.xtrip.client.fx.core.factory.FactoryToolsSupplier;
import com.gridnine.xtrip.client.fx.core.factory.FactoryToolsTracker;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomLabel;
import com.gridnine.xtrip.client.fx.core.lib.components.SearchTextField;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconIntention;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.components.progressindicator.CustomProgressIndicator;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.cells.CellsContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.cells.CellsContainerColumn;
import com.gridnine.xtrip.client.fx.core.lib.container.cells.ComplexCell;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.DelayedChangeListener;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;

class FactoryToolsPane
extends BorderPane {
    final Runnable closeCallback;
    private final ObservableMutex mutex;
    private final StackPane indicatorPane;
    private final Label captionLabel;
    private final SearchTextField patternField;
    private final CardsContainer cardsPane;
    private List<FactoryTool> loadedTools = Collections.emptyList();

    static boolean isAvailable() {
        try {
            return !FactoryToolsPane.getAvailableTools().isEmpty();
        }
        catch (Exception e) {
            ErrorHandler.handle(e);
            return false;
        }
    }

    private static List<FactoryTool> getAvailableTools() throws Exception {
        List<FactoryTool> result = ClientRegistry.get().allOf(FactoryToolsSupplier.TYPE).values().stream().flatMap(supplier -> ((Collection)supplier.get()).stream()).filter(FactoryTool::isAvaibleInConfiguration).collect(Collectors.toList());
        if (result.isEmpty()) {
            return result;
        }
        HashMap<String, AclQuery> map = new HashMap<String, AclQuery>();
        for (FactoryTool tool : result) {
            AclQuery query = tool.getACLQuery();
            if (query == null) continue;
            map.put(tool.getUid(), query);
        }
        Set<String> grantedIds = FxAclUtil.applyACL(map);
        Iterator<FactoryTool> it = result.iterator();
        while (it.hasNext()) {
            String uid = it.next().getUid();
            if (grantedIds.contains(uid) || !map.containsKey(uid)) continue;
            it.remove();
        }
        return result;
    }

    static void show() {
        Dialog dialog = new Dialog();
        dialog.setTitle(Messages.General_Creating_new_object).setBody((Node)new FactoryToolsPane(dialog::close), true).setExpandToParent(true).showGlobal();
    }

    private FactoryToolsPane(Runnable callback) {
        this.closeCallback = callback;
        this.getStyleClass().add((Object)"xtrip-factory-tools-pane");
        this.mutex = new ObservableMutex();
        ArrayList<Object> nodes = new ArrayList<Object>();
        Button button = new Button();
        button.setGraphic((Node)new IconNode(StandardIconShapes.RELOAD_12x12, (Styleable)button, StandardIconIntentions.BASIC_BUTTON_ACTION, (Styleable)button));
        button.getStyleClass().add((Object)"xtrip-button");
        UiUtil.setTooltip((Node)button, Messages.General_Refresh_util_list);
        button.disableProperty().bind((ObservableValue)this.mutex.acquiredProperty());
        button.setOnAction(evt -> this.loadTools());
        nodes.add(button);
        this.indicatorPane = new StackPane();
        GridPane.setHgrow((Node)this.indicatorPane, (Priority)Priority.NEVER);
        nodes.add(this.indicatorPane);
        this.captionLabel = new Label();
        GridPane.setHgrow((Node)this.captionLabel, (Priority)Priority.ALWAYS);
        nodes.add(this.captionLabel);
        this.patternField = new SearchTextField(){

            public void clear() {
                super.clear();
                FactoryToolsPane.this.updateCards();
            }
        };
        UiUtil.setTooltip((Node)this.patternField, Messages.General_Fast_find_utils);
        GridPane.setHgrow((Node)this.patternField, (Priority)Priority.NEVER);
        this.patternField.textProperty().addListener((ChangeListener)new DelayedChangeListener<String>(Duration.millis((double)700.0)){

            @Override
            protected void handle(String value) {
                FactoryToolsPane.this.updateCards();
            }
        });
        nodes.add((Object)this.patternField);
        GridPane pane = new GridPane();
        pane.getStyleClass().add((Object)"header-pane");
        pane.addRow(0, nodes.toArray(new Node[nodes.size()]));
        this.setTop((Node)pane);
        this.cardsPane = new CardsContainer();
        ScrollPane sp = new ScrollPane((Node)this.cardsPane);
        sp.getStyleClass().add((Object)"edge-to-edge");
        sp.setFitToWidth(true);
        sp.setFitToHeight(true);
        this.setCenter((Node)sp);
        this.mutex.acquiredProperty().addListener((s, o, n) -> {
            if (n.booleanValue()) {
                if (this.indicatorPane.getChildren().isEmpty()) {
                    this.indicatorPane.getChildren().add((Object)new CustomProgressIndicator());
                }
            } else {
                this.indicatorPane.getChildren().clear();
            }
        });
        this.loadTools();
    }

    private void loadTools() {
        this.captionLabel.setText(Messages.General_Loading_util_list);
        Notifications.get().submitTask(() -> {
            List<FactoryTool> tools = FactoryToolsPane.getAvailableTools();
            FxUtil.submitToFxThread(() -> {
                this.loadedTools = tools;
                this.updateCards();
                this.captionLabel.setText(null);
            });
        }, this.mutex);
    }

    private List<Card<Node>> buildCards(Predicate<FactoryTool> filter) {
        HashMap uid2tool = new HashMap();
        HashMap category2tools = new HashMap();
        Stream<Object> stream = this.loadedTools.stream();
        if (filter != null) {
            stream = stream.filter(filter);
        }
        stream.forEach(tool -> {
            uid2tool.put(tool.getUid(), tool);
            ArrayList<FactoryTool> list = (ArrayList<FactoryTool>)category2tools.get(tool.getCategory());
            if (list == null) {
                list = new ArrayList<FactoryTool>();
                category2tools.put(tool.getCategory(), list);
            }
            list.add((FactoryTool)tool);
        });
        List<FactoryTool> popular = FactoryToolsTracker.getPopular().filter(uid -> uid2tool.containsKey(uid)).limit(12L).map(uid -> (FactoryTool)uid2tool.get(uid)).collect(Collectors.toList());
        ArrayList<Card<Node>> result = new ArrayList<Card<Node>>();
        if (!popular.isEmpty()) {
            Card<Node> card = new Card<Node>("most-popular", UiCardsContainer.Style.EXPANDED, Messages.General_Most_popular, this.buildToolsPane(popular, true));
            card.addTitleStyle("most-popular-tools");
            result.add(card);
        }
        category2tools.entrySet().stream().sorted((entry1, entry2) -> FactoryToolCategory.COMPARATOR.compare((FactoryToolCategory)entry1.getKey(), (FactoryToolCategory)entry2.getKey())).forEach(entry -> {
            Collections.sort((List)entry.getValue(), FactoryTool.COMPARATOR);
            result.add(new Card<Node>(((FactoryToolCategory)entry.getKey()).getId(), filter == null ? UiCardsContainer.Style.COLLAPSED : UiCardsContainer.Style.EXPANDED, ((FactoryToolCategory)entry.getKey()).getName(), this.buildToolsPane((Collection)entry.getValue(), false)));
        });
        return result;
    }

    private Node buildToolsPane(Collection<FactoryTool> tools, boolean isPopular) {
        int COLUMN_NUMBER = 4;
        CellsContainer result = new CellsContainer();
        result.getStyleClass().add((Object)"tools-pane");
        IntStream.range(0, 4).forEach(i -> result.getColumns().add((Object)new CellsContainerColumn(25.0)));
        tools.stream().map(tool -> {
            GridPane gridPane = new GridPane();
            IconNode tag = this.createTag((FactoryTool)tool, isPopular, gridPane);
            StackPane iconPane = new StackPane(new Node[]{tag});
            CustomLabel label = new CustomLabel(TextUtil.isBlank((String)tool.getName()) ? Messages.General_Without_name : tool.getName());
            StackPane labelPane = new StackPane(new Node[]{label});
            StackPane stubPane = new StackPane();
            gridPane.add((Node)iconPane, 0, 0);
            gridPane.add((Node)labelPane, 1, 0);
            gridPane.add((Node)stubPane, 2, 0);
            GridPane.setFillHeight((Node)iconPane, (Boolean)Boolean.FALSE);
            GridPane.setHgrow((Node)labelPane, (Priority)Priority.ALWAYS);
            GridPane.setValignment((Node)iconPane, (VPos)VPos.TOP);
            GridPane.setHalignment((Node)iconPane, (HPos)HPos.CENTER);
            GridPane.setHalignment((Node)labelPane, (HPos)HPos.CENTER);
            gridPane.getStyleClass().add((Object)"tool-pane");
            iconPane.getStyleClass().add((Object)"side-pane");
            stubPane.getStyleClass().add((Object)"side-pane");
            labelPane.getStyleClass().add((Object)"label-pane");
            label.setWrapText(true);
            gridPane.setOnMouseClicked(evt -> {
                if (evt.getButton() != MouseButton.PRIMARY) {
                    return;
                }
                evt.consume();
                FactoryToolsTracker.onExecute(tool);
                tool.execute();
                this.closeCallback.run();
            });
            return new ComplexCell<GridPane>(gridPane);
        }).collect(Collectors.toCollection(result::getCells));
        return result;
    }

    private IconNode createTag(FactoryTool tool, boolean isPopular, GridPane gridPane) {
        IconIntention intention = isPopular ? StandardIconIntentions.FACTORY_TOOLS_TAG_POPULAR_ACTION : (!tool.isAuxiliary() && tool.getCategory() != null ? tool.getCategory().getIntention() : StandardIconIntentions.FACTORY_TOOLS_BASIC_TAG_ACTION);
        return new IconNode(StandardIconShapes.FACTORY_TOOLS_TAG, (Styleable)gridPane, intention, (Styleable)gridPane);
    }

    void updateCards() {
        String pattern;
        Predicate<FactoryTool> filter = null;
        String string = pattern = TextUtil.isBlank((String)this.patternField.getText()) ? null : this.patternField.getText().toLowerCase(Locale.ROOT);
        if (pattern != null) {
            filter = tool -> tool.getName() != null && tool.getName().toLowerCase(Locale.ROOT).contains(pattern);
        }
        this.cardsPane.getCards().setAll(this.buildCards(filter));
    }
}

