/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.ui.navigation;

import com.gridnine.xtrip.client.fx.core.ui.navigation.NavTool;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.common.fx.assets.FxWorkspaceItem;
import com.gridnine.xtrip.common.util.XSerializable;

class NavToolItem {
    private final FxWorkspaceItem item;
    private final NavTool<XSerializable> tool;
    private XSerializable parameters;

    NavToolItem(FxWorkspaceItem item) {
        this.item = item;
        this.tool = NavTool.forId(item.getToolId());
    }

    void navigate() {
        if (this.tool == null) {
            return;
        }
        if (this.item.getParameters() != null && this.parameters == null) {
            try {
                this.parameters = this.tool.cleanParameters(this.tool.getSerializer().deserialize(this.item.getParameters()));
            }
            catch (Exception e) {
                ErrorHandler.handle(e);
                return;
            }
        }
        this.tool.execute(this.item.getUid(), this.item.getName(), this.item.getName(), this.parameters, true, false, false);
    }

    boolean isNavigatable() {
        if (this.tool == null) {
            return false;
        }
        return this.tool.isExecutable();
    }

    FxWorkspaceItem getWorkspaceItem() {
        return this.item;
    }

    NavTool<XSerializable> getTool() {
        return this.tool;
    }
}

