/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.ui.navigation;

import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.factory.FactoryTool;
import com.gridnine.xtrip.client.fx.core.factory.FactoryToolsSupplier;
import com.gridnine.xtrip.client.fx.core.factory.FactoryToolsTracker;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.ClearableTextField;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomTextField;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.components.progressindicator.CustomProgressIndicator;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.service.WindowTitleService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.ui.navigation.FactoryToolsPane;
import com.gridnine.xtrip.client.fx.core.ui.navigation.NavToolItem;
import com.gridnine.xtrip.client.fx.core.ui.navigation.WorkspaceModificationEvent;
import com.gridnine.xtrip.client.fx.core.util.DelayedChangeListener;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.assets.FxWorkspace;
import com.gridnine.xtrip.common.fx.assets.FxWorkspaceItem;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javafx.beans.value.ChangeListener;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventDispatcher;
import javafx.geometry.HPos;
import javafx.geometry.Side;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.util.Callback;
import javafx.util.Duration;

public class NavigationPane
extends StackPane {
    static final PseudoClass APPLIED_FILTER = PseudoClass.getPseudoClass((String)"applied");
    private ContextMenu contextMenu;
    private List<FxWorkspaceItem> workspaceItems;
    CustomTextField navigationPaneFilterTextField;
    private TreeView<NavToolItem> tree;
    private Pane treePane;
    private final Consumer<WorkspaceModificationEvent> workspaceModificationListener = event -> {
        FxWorkspace workspace = event.getWorkspace();
        WindowTitleService.get().setWorkspaceName(workspace.getName());
        FxUtil.submitToFxThread(() -> {
            if (this.workspaceItems != null) {
                this.saveTreeState();
            }
            this.workspaceItems = workspace.getItems();
            this.reloadTreeView(null);
            this.restoreTreeState();
        });
    };
    private final GridPane navigationPane;
    private boolean factoryToolsAvailable;

    public NavigationPane() {
        this.getStyleClass().add((Object)"xtrip-navigation-pane");
        this.navigationPane = this.createNavigationPane();
        this.getChildren().addAll((Object[])new Node[]{this.navigationPane});
        EventBus.get().subscribe(WorkspaceModificationEvent.TYPE, this.workspaceModificationListener);
        this.treePane.getChildren().setAll((Object[])new Node[]{new CustomProgressIndicator()});
    }

    private GridPane createNavigationPane() {
        Pane filterPane = this.createNavigationPaneFilterPane();
        this.treePane = this.createTreePane();
        GridPane pane = new GridPane();
        pane.getStyleClass().add((Object)"xtrip-navigation-pane-container-pane");
        UiUtil.gridPosition(pane, (Node)filterPane).col(0).row(0).hAlignment(HPos.LEFT).vAlignment(VPos.TOP).hGrow(Priority.ALWAYS).vGrow(Priority.NEVER).place();
        UiUtil.gridPosition(pane, (Node)this.treePane).col(0).row(1).hAlignment(HPos.LEFT).vAlignment(VPos.TOP).hGrow(Priority.ALWAYS).vGrow(Priority.ALWAYS).place();
        return pane;
    }

    public void initFactoryTools() {
        if (FactoryToolsPane.isAvailable()) {
            FxUtil.submitToFxThread(() -> {
                UiUtil.gridPosition(this.navigationPane, (Node)this.createSeparatorPane()).col(0).row(2).hAlignment(HPos.LEFT).vAlignment(VPos.TOP).hGrow(Priority.ALWAYS).vGrow(Priority.NEVER).place();
                UiUtil.gridPosition(this.navigationPane, (Node)this.createButtonsPane()).col(0).row(3).hAlignment(HPos.LEFT).vAlignment(VPos.TOP).hGrow(Priority.ALWAYS).vGrow(Priority.NEVER).place();
                this.factoryToolsAvailable = true;
            });
        }
    }

    public void showFactoryTools() {
        if (this.factoryToolsAvailable) {
            FactoryToolsPane.show();
        }
    }

    private Pane createNavigationPaneFilterPane() {
        this.navigationPaneFilterTextField = new ClearableTextField();
        this.navigationPaneFilterTextField.setId("xtrip-navigation-filter");
        UiUtil.setTooltip((Node)this.navigationPaneFilterTextField, Messages.General_Fast_find_in_navigation_panel);
        StackPane filterIcon = new StackPane(new Node[]{new Region()});
        filterIcon.getStyleClass().add((Object)"left-button");
        this.navigationPaneFilterTextField.setLeft((Node)filterIcon);
        this.navigationPaneFilterTextField.setPromptText(Messages.General_Clarify_name);
        StackPane navigationPaneFilterContainerPane = new StackPane();
        navigationPaneFilterContainerPane.getStyleClass().add((Object)"xtrip-navigation-pane-filter-container-pane");
        this.navigationPaneFilterTextField.textProperty().addListener((ChangeListener)new DelayedChangeListener<String>(Duration.millis((double)700.0)){

            @Override
            protected void handle(String value) {
                NavigationPane.this.navigationPaneFilterTextField.pseudoClassStateChanged(APPLIED_FILTER, !TextUtil.isBlank((String)value));
                NavigationPane.this.reloadTreeView(value);
            }
        });
        this.navigationPaneFilterTextField.textProperty().addListener(e -> this.navigationPaneFilterTextField.pseudoClassStateChanged(APPLIED_FILTER, !this.navigationPaneFilterTextField.getText().equals("")));
        navigationPaneFilterContainerPane.getChildren().addAll((Object[])new Node[]{this.navigationPaneFilterTextField});
        return navigationPaneFilterContainerPane;
    }

    private Pane createTreePane() {
        this.tree = new TreeView();
        this.tree.getStyleClass().setAll((Object[])new String[]{"xtrip-tree-view"});
        this.tree.setEventDispatcher((EventDispatcher)new TreeViewEventDispatcher(this.tree.getEventDispatcher()));
        this.tree.setCellFactory((Callback)new Callback<TreeView<NavToolItem>, TreeCell<NavToolItem>>(){

            public TreeCell<NavToolItem> call(TreeView<NavToolItem> param) {
                return new NavigationTreeCell();
            }
        });
        this.tree.setShowRoot(false);
        GridPane pane = new GridPane();
        pane.getStyleClass().add((Object)"tree-pane");
        UiUtil.gridPosition(pane, this.tree).col(0).row(0).hAlignment(HPos.LEFT).vAlignment(VPos.TOP).hGrow(Priority.ALWAYS).vGrow(Priority.ALWAYS).place();
        return pane;
    }

    private Pane createSeparatorPane() {
        IconNode icon = new IconNode(StandardIconShapes.DOTS_42X6, StandardIconIntentions.NAVIGATION_SEPARATOR);
        GridPane pane = new GridPane();
        pane.getStyleClass().add((Object)"separator-pane");
        UiUtil.gridPosition(pane, (Node)icon).col(0).row(0).hAlignment(HPos.CENTER).vAlignment(VPos.CENTER).hGrow(Priority.ALWAYS).vGrow(Priority.ALWAYS).place();
        return pane;
    }

    private Pane createButtonsPane() {
        Button buttonCreate = new Button(Messages.General_Create1);
        buttonCreate.getStyleClass().add((Object)"navigation-button-create");
        Button buttonMore = new Button(null, (Node)new Region());
        buttonMore.getStyleClass().add((Object)"navigation-button-more");
        buttonCreate.setOnAction(evt -> FactoryToolsPane.show());
        buttonMore.setOnAction(evt -> this.showRecentFactoryTools((Node)buttonMore));
        HBox buttonsPane = new HBox(new Node[]{buttonCreate, buttonMore});
        buttonsPane.getStyleClass().add((Object)"buttons-pane");
        GridPane pane = new GridPane();
        pane.getStyleClass().add((Object)"xtrip-navigation-buttons-pane");
        UiUtil.gridPosition(pane, (Node)buttonsPane).col(0).row(0).hAlignment(HPos.CENTER).vAlignment(VPos.CENTER).hGrow(Priority.ALWAYS).vGrow(Priority.ALWAYS).place();
        return pane;
    }

    private void showRecentFactoryTools(Node anchor) {
        if (this.contextMenu != null && this.contextMenu.isShowing()) {
            this.contextMenu.hide();
            return;
        }
        if (this.contextMenu == null) {
            this.contextMenu = new ContextMenu();
            this.contextMenu.getStyleClass().add((Object)"navigation-dropdown");
        }
        Notifications.get().submitTask(() -> {
            ArrayList<MenuItem> items = new ArrayList<MenuItem>();
            MenuItem labelMenuItem = new MenuItem(Messages.General_Last_created);
            labelMenuItem.setDisable(true);
            labelMenuItem.getStyleClass().add((Object)"label-menu-item");
            items.add(labelMenuItem);
            List<FactoryTool> tools = FactoryToolsTracker.getRecent();
            if (!tools.isEmpty()) {
                Collections.reverse(tools);
                for (FactoryTool tool : tools) {
                    boolean availableForUse = ClientRegistry.get().allOf(FactoryToolsSupplier.TYPE).values().stream().flatMap(supplier -> ((Collection)supplier.get()).stream()).anyMatch(factoryTool -> tool.getUid().equals(factoryTool.getUid()));
                    if (!availableForUse) continue;
                    MenuItem item = new MenuItem(tool.getName());
                    item.setOnAction(evt -> {
                        FactoryToolsTracker.onExecute(tool);
                        tool.execute();
                    });
                    items.add(item);
                }
            }
            FxUtil.waitForFxThread(() -> {
                this.contextMenu.getItems().setAll((Collection)items);
                this.contextMenu.show(anchor, Side.TOP, 0.0, 0.0);
                this.contextMenu.hide();
                this.contextMenu.show(this.contextMenu.getOwnerNode(), Side.TOP, 0.0, -10.0);
            });
        }, ObservableMutex.lookup(anchor));
    }

    public TreeView<NavToolItem> getTree() {
        return this.tree;
    }

    protected void reloadTreeView(String filterText) {
        TreeItem root = new TreeItem();
        if (this.workspaceItems != null) {
            for (FxWorkspaceItem workspaceItem : this.workspaceItems) {
                this.createTreeItem((TreeItem<NavToolItem>)root, workspaceItem, filterText);
            }
        }
        this.tree.setRoot(root);
        this.treePane.getChildren().setAll((Object[])new Node[]{this.tree});
    }

    private void createTreeItem(TreeItem<NavToolItem> parent, FxWorkspaceItem workspaceItem, String filterText) {
        if (this.isMatchFilter(workspaceItem, filterText)) {
            NavToolItem item = new NavToolItem(workspaceItem);
            if (item.getTool() == null) {
                return;
            }
            TreeItem treeItem = new TreeItem((Object)item);
            for (FxWorkspaceItem childItem : workspaceItem.getSubItems()) {
                this.createTreeItem((TreeItem<NavToolItem>)treeItem, childItem, filterText);
            }
            parent.getChildren().add((Object)treeItem);
        }
    }

    private boolean isMatchFilter(FxWorkspaceItem workspaceItem, String filterText) {
        if (filterText == null) {
            return true;
        }
        if (workspaceItem == null || workspaceItem.getName() == null) {
            return false;
        }
        return workspaceItem.getName().toLowerCase().contains(filterText.toLowerCase()) || this.isMatchFilter(workspaceItem.getSubItems(), filterText);
    }

    private boolean isMatchFilter(List<FxWorkspaceItem> items, String filterText) {
        for (FxWorkspaceItem item : items) {
            if (!this.isMatchFilter(item, filterText)) continue;
            return true;
        }
        return false;
    }

    public void saveTreeState() {
        ArrayList<String> uids = new ArrayList<String>();
        this.collectExpanded(uids, (TreeItem<NavToolItem>)this.tree.getRoot());
        File file = new File(Environment.getDataFolder(), "settings/nav-tree-state.dat");
        file.getParentFile().mkdirs();
        try {
            Files.write(file.toPath(), uids, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException ioe) {
            ErrorHandler.handle(ioe);
        }
    }

    private void collectExpanded(List<String> uids, TreeItem<NavToolItem> item) {
        if (item == null) {
            return;
        }
        if (item.isExpanded() && item.getValue() != null) {
            uids.add(((NavToolItem)item.getValue()).getWorkspaceItem().getUid());
        }
        for (TreeItem child : item.getChildren()) {
            this.collectExpanded(uids, (TreeItem<NavToolItem>)child);
        }
    }

    private void restoreTreeState() {
        HashSet<String> uids;
        File file = new File(Environment.getDataFolder(), "settings/nav-tree-state.dat");
        if (!file.isFile()) {
            return;
        }
        try {
            uids = new HashSet<String>(Files.readAllLines(file.toPath()));
        }
        catch (IOException ioe) {
            ErrorHandler.handle(ioe);
            return;
        }
        this.expand(uids, (TreeItem<NavToolItem>)this.tree.getRoot());
    }

    private void expand(Set<String> uids, TreeItem<NavToolItem> item) {
        if (item.getValue() != null) {
            item.setExpanded(uids.contains(((NavToolItem)item.getValue()).getWorkspaceItem().getUid()));
        }
        for (TreeItem child : item.getChildren()) {
            this.expand(uids, (TreeItem<NavToolItem>)child);
        }
    }

    private static class NavigationTreeCellPane
    extends StackPane {
        private final IconNode imageIcon;
        private final Label titleLabel;
        private final IconNode rulerButtonIcon;

        public NavigationTreeCellPane(TreeCell<?> cell) {
            this.imageIcon = new IconNode(StandardIconShapes.UNDEFINED, (Styleable)cell, StandardIconIntentions.NAVIGATION_TREE_CELL_DECORATION, (Styleable)cell);
            this.imageIcon.getStyleClass().add((Object)"image-icon");
            this.titleLabel = new Label();
            this.titleLabel.getStyleClass().add((Object)"title-label");
            this.rulerButtonIcon = new IconNode(StandardIconShapes.RULER_14X14, (Styleable)cell, StandardIconIntentions.NAVIGATION_TREE_CELL_BUTTON_RULER, (Styleable)cell);
            this.rulerButtonIcon.getStyleClass().add((Object)"button-icon");
            GridPane containerPane = new GridPane();
            containerPane.getStyleClass().add((Object)"container-pane");
            UiUtil.gridPosition(containerPane, (Node)this.imageIcon).col(0).row(0).hAlignment(HPos.LEFT).hGrow(Priority.NEVER).vGrow(Priority.NEVER).place();
            UiUtil.gridPosition(containerPane, (Node)this.titleLabel).col(1).row(0).hAlignment(HPos.LEFT).hGrow(Priority.ALWAYS).vGrow(Priority.NEVER).place();
            UiUtil.gridPosition(containerPane, (Node)this.rulerButtonIcon).col(2).row(0).hAlignment(HPos.LEFT).hGrow(Priority.NEVER).vGrow(Priority.NEVER).place();
            this.getChildren().addAll((Object[])new Node[]{containerPane});
        }

        public IconNode getImageIcon() {
            return this.imageIcon;
        }

        public Label getTitleLabel() {
            return this.titleLabel;
        }

        public IconNode getRulerButtonIcon() {
            return this.rulerButtonIcon;
        }
    }

    class NavigationTreeCell
    extends TreeCell<NavToolItem> {
        private NavigationTreeCellPane pane;

        public NavigationTreeCell() {
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            this.hoverProperty().addListener(observable -> this.updateItem((NavToolItem)this.getItem(), this.isEmpty()));
        }

        public void updateItem(NavToolItem value, boolean empty) {
            super.updateItem((Object)value, empty);
            this.setDisclosureNode(null);
            if (!empty) {
                TreeItem item;
                if (this.pane == null) {
                    this.pane = new NavigationTreeCellPane(this);
                    this.setOnMousePressed(event -> {
                        TreeItem item = this.getTreeItem();
                        if (item == null) {
                            return;
                        }
                        ((NavToolItem)item.getValue()).navigate();
                        if (!((NavToolItem)item.getValue()).isNavigatable() && !item.isLeaf()) {
                            item.setExpanded(!item.isExpanded());
                        }
                        event.consume();
                    });
                    this.pane.getRulerButtonIcon().setOnMousePressed(event -> {
                        TreeItem item = this.getTreeItem();
                        if (item == null) {
                            return;
                        }
                        item.setExpanded(!item.isExpanded());
                        event.consume();
                    });
                }
                if ((item = this.getTreeItem()) != null) {
                    this.pane.getImageIcon().setIconShape(value.getTool().getShape(item.isLeaf()));
                    this.pane.getTitleLabel().setText(value.getWorkspaceItem().getName());
                    this.pane.getRulerButtonIcon().setVisible(!item.isLeaf());
                }
                this.setGraphic((Node)this.pane);
            } else {
                this.setGraphic(null);
            }
            this.setText(null);
        }
    }

    private static class TreeViewEventDispatcher
    implements EventDispatcher {
        private final EventDispatcher eventDispatcher;

        public TreeViewEventDispatcher(EventDispatcher eventDispatcher) {
            this.eventDispatcher = eventDispatcher;
        }

        public Event dispatchEvent(Event event, EventDispatchChain tail) {
            if (event instanceof MouseEvent && ((MouseEvent)event).getButton() == MouseButton.PRIMARY && ((MouseEvent)event).getClickCount() >= 2) {
                event.consume();
            }
            return this.eventDispatcher.dispatchEvent(event, tail);
        }
    }
}

