/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.ui.tab;

import com.gridnine.xtrip.client.fx.core.action.ActionsPane;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.common.Disposable;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

public abstract class BaseContentPane
extends StackPane
implements Disposable {
    private static final PseudoClass EXPANDED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"expanded");
    private static final String ACTIONS_PANE_STYLE_CLASS = "xtrip-actions-pane";
    private static final String TOOLBAR_STYLE_CLASS = "xtrip-actions-pane-toolbar";
    private static final String BUTTON_LEFT_ID = "xtrip-button-left";
    private static final String BUTTON_RIGHT_ID = "xtrip-button-right";
    private static final Duration TOOLBAR_ANIMATION_DURATION = Duration.millis((double)300.0);
    private boolean actionsAnimationInProgress = false;
    private boolean disposed;

    public void dispose() {
        this.disposed = true;
        this.getChildren().clear();
    }

    protected boolean isDisposed() {
        return this.disposed;
    }

    protected void composePane(Node contentNode, Node headerNode, ActionsPane<?> actionsNode, Node filtersNode) {
        StackPane actionsWithFiltersPane = new StackPane();
        Rectangle clipRectangle = new Rectangle();
        actionsWithFiltersPane.setClip((Node)clipRectangle);
        actionsWithFiltersPane.layoutBoundsProperty().addListener((observable, oldValue, newValue) -> {
            clipRectangle.setWidth(newValue.getWidth());
            clipRectangle.setHeight(newValue.getHeight());
        });
        if (actionsNode != null) {
            Region actionBar = this.createActionsContainerPane(actionsNode);
            StackPane.setAlignment(actionsNode, (Pos)Pos.CENTER_RIGHT);
            actionsWithFiltersPane.getChildren().add((Object)actionBar);
            FxUtil.addListener(actionsNode.actionsCountProperty(), (s, o, n) -> Styles.manageStyle((Styleable)actionBar, "hidden", n.intValue() == 0));
        }
        if (filtersNode != null) {
            StackPane.setAlignment((Node)filtersNode, (Pos)Pos.CENTER_RIGHT);
            actionsWithFiltersPane.getChildren().add((Object)filtersNode);
        }
        BorderPane wholePage = new BorderPane();
        wholePage.setTop(headerNode);
        wholePage.setCenter(contentNode);
        wholePage.setRight((Node)actionsWithFiltersPane);
        this.getChildren().setAll((Object[])new Node[]{wholePage});
    }

    private Region createActionsContainerPane(ActionsPane<?> actionsNode) {
        VBox result = new VBox();
        result.getStyleClass().add((Object)ACTIONS_PANE_STYLE_CLASS);
        Pane toolbarPane = this.createActionsToolbarPane(actionsNode);
        result.getChildren().add((Object)toolbarPane);
        result.getChildren().add(actionsNode);
        toolbarPane.widthProperty().addListener((o, oldW, newWidth) -> {
            if (this.actionsAnimationInProgress) {
                actionsNode.setPrefWidth(newWidth.doubleValue());
                actionsNode.setMinWidth(newWidth.doubleValue());
                actionsNode.setMaxWidth(newWidth.doubleValue());
                actionsNode.requestLayout();
            }
        });
        return result;
    }

    private Pane createActionsToolbarPane(ActionsPane<?> actionsPane) {
        BorderPane result = new BorderPane();
        result.getStyleClass().add((Object)TOOLBAR_STYLE_CLASS);
        Button expandButton = new Button();
        expandButton.setId(BUTTON_LEFT_ID);
        UiUtil.setTooltip((Node)expandButton, Messages.General_Expand);
        Button collapseButton = new Button();
        expandButton.setGraphic((Node)new IconNode(StandardIconShapes.RULE_ACTION_PANE_10x16, (Styleable)expandButton, StandardIconIntentions.EXPAND_ACTION_PANE_BUTTON_ACTION, (Styleable)expandButton));
        collapseButton.setId(BUTTON_RIGHT_ID);
        UiUtil.setTooltip((Node)collapseButton, Messages.General_Collapse);
        collapseButton.setDisable(true);
        collapseButton.setGraphic((Node)new IconNode(StandardIconShapes.RULE_ACTION_PANE_10x16, (Styleable)collapseButton, StandardIconIntentions.COLLAPSE_ACTION_PANE_BUTTON_ACTION, (Styleable)collapseButton));
        result.setOnMouseClicked(e -> {
            if (actionsPane.isExpanded()) {
                collapseButton.fire();
            } else {
                expandButton.fire();
            }
        });
        expandButton.setOnAction(e -> {
            if (!this.actionsAnimationInProgress) {
                actionsPane.setExpanded(true);
                expandButton.setDisable(true);
                collapseButton.setDisable(false);
                this.animateExpand((Pane)result, actionsPane);
            }
        });
        collapseButton.setOnAction(e -> {
            if (!this.actionsAnimationInProgress) {
                expandButton.setDisable(false);
                collapseButton.setDisable(true);
                this.animateCollapse((Pane)result, actionsPane);
            }
        });
        result.setLeft((Node)expandButton);
        result.setRight((Node)collapseButton);
        return result;
    }

    private void animateExpand(Pane toolbarPane, ActionsPane<?> actionsPane) {
        this.actionsAnimationInProgress = true;
        actionsPane.setManaged(false);
        Timeline timeline = new Timeline();
        timeline.setCycleCount(1);
        KeyValue kv = new KeyValue((WritableValue)toolbarPane.prefWidthProperty(), (Object)toolbarPane.getMaxWidth(), Interpolator.EASE_BOTH);
        KeyFrame kf = new KeyFrame(TOOLBAR_ANIMATION_DURATION, new KeyValue[]{kv});
        timeline.getKeyFrames().add((Object)kf);
        timeline.setOnFinished(e -> {
            actionsPane.setExpanded(true);
            toolbarPane.pseudoClassStateChanged(EXPANDED_PSEUDOCLASS_STATE, actionsPane.isExpanded());
            actionsPane.setManaged(true);
            this.actionsAnimationInProgress = false;
        });
        timeline.play();
    }

    private void animateCollapse(Pane toolbarPane, ActionsPane<?> actionsPane) {
        this.actionsAnimationInProgress = true;
        actionsPane.setManaged(false);
        Timeline timeline = new Timeline();
        timeline.setCycleCount(1);
        KeyValue kv = new KeyValue((WritableValue)toolbarPane.prefWidthProperty(), (Object)toolbarPane.getMinWidth(), Interpolator.EASE_BOTH);
        KeyFrame kf = new KeyFrame(TOOLBAR_ANIMATION_DURATION, new KeyValue[]{kv});
        timeline.getKeyFrames().add((Object)kf);
        timeline.setOnFinished(e -> {
            actionsPane.setExpanded(false);
            toolbarPane.pseudoClassStateChanged(EXPANDED_PSEUDOCLASS_STATE, actionsPane.isExpanded());
            actionsPane.setManaged(true);
            this.actionsAnimationInProgress = false;
        });
        timeline.play();
    }
}

