/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.ui.tab;

import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.ui.tab.TabPaneControls;
import com.gridnine.xtrip.client.fx.core.ui.tab.TabPaneTab;
import javafx.beans.value.ChangeListener;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.event.EventHandler;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;

class TabPaneControlsSkin
extends StackPane {
    private final TabPaneControls controls;
    private ContextMenu contextMenu;

    public TabPaneControlsSkin(TabPaneControls controls) {
        this.controls = controls;
        this.getStyleClass().setAll(controls.getStyleClass());
        this.setId(controls.getId());
        this.setStyle(controls.getStyle());
        this.createGUI();
        this.createListeners();
    }

    public TabPaneControls getControls() {
        return this.controls;
    }

    private void createGUI() {
        Pane controlsPane = this.createControlsPane();
        this.getChildren().add((Object)controlsPane);
    }

    private Pane createControlsPane() {
        final IconNode menuButtonIcon = new IconNode(StandardIconShapes.MORE_18X18, (Styleable)this, StandardIconIntentions.TABS_MENU, (Styleable)this);
        menuButtonIcon.getStyleClass().add((Object)"button-icon");
        StackPane pane = new StackPane(){

            protected void layoutChildren() {
                double width = this.snapSize(this.getWidth());
                double height = this.snapSize(this.getHeight());
                double buttonIconWidth = this.snapSize(menuButtonIcon.prefWidth(-1.0));
                double buttonIconHeight = this.snapSize(menuButtonIcon.prefHeight(-1.0));
                double buttonIconX = this.snapSize((width - buttonIconWidth) / 2.0);
                double buttonIconY = this.snapSize((height - buttonIconHeight) / 2.0);
                System.out.println("=====================================");
                System.out.println("width -> " + width);
                System.out.println("height -> " + height);
                System.out.println("buttonWidth -> " + buttonIconWidth);
                System.out.println("buttonHeight -> " + buttonIconHeight);
                menuButtonIcon.resize(buttonIconWidth, buttonIconHeight);
                menuButtonIcon.relocate(buttonIconX, buttonIconY);
            }
        };
        pane.getChildren().addAll((Object[])new Node[]{menuButtonIcon});
        return pane;
    }

    private void createListeners() {
        this.controls.getTabPane().getRegularTabs().addListener(change -> {
            if (this.contextMenu != null) {
                this.contextMenu.getItems().stream().map(menuItem -> (TabMenuItem)((Object)((Object)menuItem))).forEach(TabMenuItem::dispose);
            }
            this.contextMenu = new ContextMenu();
            this.contextMenu.setOnAction(event -> {
                TabMenuItem item = (TabMenuItem)event.getTarget();
                this.controls.getTabPane().getRegularTabsSelectionModel().select((Object)item.getTab());
            });
            this.contextMenu.setOnShown(event -> {
                double maxWidth = this.contextMenu.getItems().stream().mapToDouble(menuItem -> ((Label)((BorderPane)((TabMenuItem)((Object)((Object)((Object)menuItem)))).getContent()).getCenter()).getWidth()).max().getAsDouble();
                for (MenuItem item : this.contextMenu.getItems()) {
                    ((Label)((BorderPane)((TabMenuItem)item).getContent()).getCenter()).minWidthProperty().set(maxWidth);
                }
            });
            TabMenuItem previousItem = null;
            for (TabPaneTab regularTab : this.controls.getTabPane().getRegularTabs()) {
                TabMenuItem item = new TabMenuItem(regularTab, previousItem);
                this.contextMenu.getItems().add((Object)item);
                previousItem = item;
            }
            this.contextMenu.show((Node)this, Side.BOTTOM, Double.MIN_VALUE, Double.MIN_VALUE);
            this.contextMenu.hide();
            this.requestLayout();
        });
        this.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (event.getButton().equals((Object)MouseButton.PRIMARY)) {
                    if (TabPaneControlsSkin.this.contextMenu != null) {
                        if (!TabPaneControlsSkin.this.contextMenu.isShowing()) {
                            TabPaneControlsSkin.this.contextMenu.show((Node)TabPaneControlsSkin.this, Side.BOTTOM, TabPaneControlsSkin.this.getWidth() - TabPaneControlsSkin.this.contextMenu.getWidth(), 0.0);
                        } else {
                            TabPaneControlsSkin.this.contextMenu.hide();
                        }
                    }
                    event.consume();
                }
            }
        });
    }

    private class TabMenuItem
    extends CustomMenuItem {
        private final TabPaneTab tab;
        private final BorderPane borderPane = new BorderPane();
        private final ChangeListener<Boolean> selectedPropertyListener;
        private final ChangeListener<Boolean> hoverPropertyListener;
        private final ChangeListener<String> textPropertyListener;
        private final ChangeListener<Boolean> hightlightedPropertyListener;

        public TabMenuItem(TabPaneTab tab, TabMenuItem previousItem) {
            this.tab = tab;
            Label decorationLabel = new Label();
            decorationLabel.getStyleClass().add((Object)"tab-decoration-label");
            decorationLabel.setVisible(false);
            Label textLabel = new Label(tab.getText());
            this.borderPane.getStyleClass().add((Object)"wrap");
            this.borderPane.setLeft((Node)decorationLabel);
            this.borderPane.setCenter((Node)textLabel);
            this.hoverPropertyListener = (observable, oldValue, newValue) -> {
                if (previousItem != null) {
                    previousItem.borderPane.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"above-hover"), newValue.booleanValue());
                }
            };
            this.borderPane.hoverProperty().addListener(this.hoverPropertyListener);
            this.selectedPropertyListener = (observable, oldValue, newValue) -> Styles.manageStyle((Styleable)this.borderPane, "selected-tab", newValue);
            tab.selectedProperty().addListener(this.selectedPropertyListener);
            this.textPropertyListener = (observable, oldValue, newValue) -> textLabel.setText(tab.getText());
            tab.textProperty().addListener(this.textPropertyListener);
            this.hightlightedPropertyListener = (observable, oldValue, newValue) -> this.applyHighlightedStyle((Boolean)newValue);
            tab.highlightedProperty().addListener(this.hightlightedPropertyListener);
            this.applyHighlightedStyle(tab.highlightedProperty().getValue());
            this.setContent((Node)this.borderPane);
        }

        void applyHighlightedStyle(Boolean value) {
            Styles.manageStyle((Styleable)this.borderPane, "edited-tab", value);
        }

        public TabPaneTab getTab() {
            return this.tab;
        }

        void dispose() {
            this.borderPane.hoverProperty().removeListener(this.hoverPropertyListener);
            this.tab.selectedProperty().removeListener(this.selectedPropertyListener);
            this.tab.textProperty().removeListener(this.textPropertyListener);
            this.tab.highlightedProperty().removeListener(this.hightlightedPropertyListener);
        }
    }
}

