/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.ui.tab;

import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconShape;
import com.gridnine.xtrip.client.fx.core.ui.tab.TabPane;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableProperty;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Tooltip;

public class TabPaneTab
implements Styleable {
    public static final EventType<Event> CLOSED_EVENT = new EventType(Event.ANY, "CLOSED_EVENT");
    public static final EventType<Event> CLOSE_REQUEST_EVENT = new EventType(Event.ANY, "CLOSE_REQUEST_EVENT");
    private static final String DEFAULT_STYLE_CLASS = "xtrip-tab";
    private static final double DEFAULT_ICON_WIDTH = 25.0;
    private final ObservableList<String> styleClass = FXCollections.observableArrayList();
    private DoubleProperty iconWidth;
    private BooleanProperty closable;
    private BooleanProperty busy;
    private BooleanProperty special;
    private DoubleProperty progress;
    private StringProperty text;
    private ObjectProperty<Tooltip> tooltip;
    private ObjectProperty<IconShape> icon;
    private ObjectProperty<Node> graphic;
    private Node content;
    private ObservableMap<Object, Object> properties;
    private ObjectProperty<EventHandler<Event>> onClosed;
    private ObjectProperty<EventHandler<Event>> onCloseRequest;
    private final ReadOnlyBooleanWrapper selected = new ReadOnlyBooleanWrapper((Object)this, "selected");
    private TabPane tabPane;
    private final SimpleBooleanProperty highlighted = new SimpleBooleanProperty();
    private StringProperty id;
    private StringProperty style;

    public TabPaneTab() {
        this(null);
    }

    public TabPaneTab(String text) {
        this(text, null);
    }

    public TabPaneTab(String text, Node content) {
        this.setText(text);
        this.setContent(content);
        this.styleClass.addAll((Object[])new String[]{DEFAULT_STYLE_CLASS});
    }

    public final void setIconWidth(double value) {
        this.iconWidthProperty().setValue((Number)value);
    }

    public final double getIconWidth() {
        return this.iconWidth != null ? this.iconWidth.getValue() : 25.0;
    }

    public final DoubleProperty iconWidthProperty() {
        if (this.iconWidth == null) {
            this.iconWidth = new StyleableDoubleProperty(25.0){

                public CssMetaData<TabPaneTab, Number> getCssMetaData() {
                    return StyleableProperties.ICON_WIDTH;
                }

                public Object getBean() {
                    return TabPaneTab.this;
                }

                public String getName() {
                    return "iconWidth";
                }
            };
        }
        return this.iconWidth;
    }

    public final BooleanProperty closableProperty() {
        if (this.closable == null) {
            this.closable = new SimpleBooleanProperty((Object)this, "closable", true);
        }
        return this.closable;
    }

    public final void setClosable(boolean value) {
        this.closableProperty().set(value);
    }

    public final boolean isClosable() {
        return this.closable != null ? this.closable.get() : true;
    }

    public final BooleanProperty busyProperty() {
        if (this.busy == null) {
            this.busy = new SimpleBooleanProperty((Object)this, "busy");
        }
        return this.busy;
    }

    public final void setBusy(boolean value) {
        this.busyProperty().set(value);
    }

    public final boolean isBusy() {
        return this.busy != null ? this.busy.get() : true;
    }

    public final BooleanProperty specialProperty() {
        if (this.special == null) {
            this.special = new SimpleBooleanProperty((Object)this, "special");
        }
        return this.special;
    }

    public final void setSpecial(boolean value) {
        this.specialProperty().set(value);
    }

    public final boolean isSpecial() {
        return this.special != null ? this.special.get() : true;
    }

    public final DoubleProperty progressProperty() {
        if (this.progress == null) {
            this.progress = new SimpleDoubleProperty((Object)this, "progress");
        }
        return this.progress;
    }

    public final void setProgress(double value) {
        this.progressProperty().set(value);
    }

    public final double getProgress() {
        return this.progress != null ? this.progress.get() : 0.0;
    }

    public final StringProperty textProperty() {
        if (this.text == null) {
            this.text = new SimpleStringProperty((Object)this, "text");
        }
        return this.text;
    }

    public final void setText(String value) {
        this.textProperty().set((Object)value);
    }

    public final String getText() {
        return this.text != null ? (String)this.text.get() : null;
    }

    public final ObjectProperty<Tooltip> tooltipProperty() {
        if (this.tooltip == null) {
            this.tooltip = new SimpleObjectProperty((Object)this, "tooltip");
        }
        return this.tooltip;
    }

    public final void setTooltip(Tooltip value) {
        this.tooltipProperty().set((Object)value);
    }

    public final Tooltip getTooltip() {
        return this.tooltip != null ? (Tooltip)this.tooltip.get() : null;
    }

    public final void setIcon(IconShape value) {
        this.iconProperty().set((Object)value);
    }

    public final IconShape getIcon() {
        return this.icon != null ? (IconShape)this.icon.get() : null;
    }

    public final ObjectProperty<IconShape> iconProperty() {
        if (this.icon == null) {
            this.icon = new SimpleObjectProperty((Object)this, "icon");
        }
        return this.icon;
    }

    public final ObjectProperty<Node> graphicProperty() {
        if (this.graphic == null) {
            this.graphic = new SimpleObjectProperty((Object)this, "graphic");
        }
        return this.graphic;
    }

    public final void setGraphic(Node value) {
        this.graphicProperty().set((Object)value);
    }

    public final Node getGraphic() {
        return this.graphic != null ? (Node)this.graphic.get() : null;
    }

    public final void setContent(Node value) {
        if (this.content != null && this.tabPane != null && this.tabPane.getContentPane() != null) {
            this.tabPane.getContentPane().getChildren().remove((Object)this.content);
        }
        this.content = value;
        if (this.content != null) {
            this.content.setVisible(this.isSelected());
            if (this.tabPane != null && this.tabPane.getContentPane() != null) {
                this.tabPane.getContentPane().getChildren().add((Object)this.content);
            }
        }
    }

    public final Node getContent() {
        return this.content;
    }

    public final ObservableMap<Object, Object> getProperties() {
        if (this.properties == null) {
            this.properties = FXCollections.observableMap(new HashMap());
        }
        return this.properties;
    }

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public final ObjectProperty<EventHandler<Event>> onClosedProperty() {
        if (this.onClosed == null) {
            this.onClosed = new SimpleObjectProperty((Object)this, "onClosed");
        }
        return this.onClosed;
    }

    public final void setOnClosed(EventHandler<Event> value) {
        this.onClosedProperty().set(value);
    }

    public final EventHandler<Event> getOnClosed() {
        return this.onClosed != null ? (EventHandler)this.onClosed.get() : null;
    }

    public final ObjectProperty<EventHandler<Event>> onCloseRequestProperty() {
        if (this.onCloseRequest == null) {
            this.onCloseRequest = new SimpleObjectProperty((Object)this, "onCloseRequest");
        }
        return this.onCloseRequest;
    }

    public final void setOnCloseRequest(EventHandler<Event> value) {
        this.onCloseRequestProperty().set(value);
    }

    public final EventHandler<Event> getOnCloseRequest() {
        return this.onCloseRequest != null ? (EventHandler)this.onCloseRequest.get() : null;
    }

    final void setSelected(boolean value) {
        this.selected.set(value);
        if (this.content != null) {
            this.content.setVisible(value);
        }
    }

    public final boolean isSelected() {
        return this.selected.get();
    }

    public final ReadOnlyBooleanProperty selectedProperty() {
        return this.selected.getReadOnlyProperty();
    }

    public void setHighlighted(boolean value) {
        this.highlighted.set(value);
    }

    BooleanProperty highlightedProperty() {
        return this.highlighted;
    }

    final void setTabPane(TabPane value) {
        if (this.tabPane != null && this.tabPane.getContentPane() != null && this.content != null) {
            this.tabPane.getContentPane().getChildren().remove((Object)this.content);
        }
        this.tabPane = value;
        if (this.tabPane != null && this.tabPane.getContentPane() != null && this.content != null) {
            this.tabPane.getContentPane().getChildren().add((Object)this.content);
        }
    }

    final TabPane getTabPane() {
        return this.tabPane;
    }

    public void close() {
        boolean close = this.fireCloseEvent();
        if (close) {
            if (this.isSpecial()) {
                this.getTabPane().getSpecialTabs().remove((Object)this);
            } else {
                this.getTabPane().getRegularTabs().remove((Object)this);
            }
        }
    }

    private boolean fireCloseEvent() {
        EventHandler<Event> closedHandler;
        boolean close = true;
        EventHandler<Event> closeRequestHandler = this.getOnCloseRequest();
        if (closeRequestHandler != null) {
            Event event = new Event((Object)this, null, CLOSE_REQUEST_EVENT);
            closeRequestHandler.handle(event);
            boolean bl = close = !event.isConsumed();
        }
        if (close && (closedHandler = this.getOnClosed()) != null) {
            Event event = new Event((Object)this, null, CLOSED_EVENT);
            closedHandler.handle(event);
        }
        return close;
    }

    Node lookup(String selector) {
        if (selector == null) {
            return null;
        }
        Node node = null;
        if (this.getContent() != null) {
            node = this.getContent().lookup(selector);
        }
        if (node == null && this.getGraphic() != null) {
            node = this.getGraphic().lookup(selector);
        }
        return node;
    }

    List<Node> lookupAll(String selector) {
        Set set;
        ArrayList<Node> nodes = new ArrayList<Node>();
        if (this.getContent() != null && !(set = this.getContent().lookupAll(selector)).isEmpty()) {
            nodes.addAll(set);
        }
        if (this.getGraphic() != null && !(set = this.getGraphic().lookupAll(selector)).isEmpty()) {
            nodes.addAll(set);
        }
        return nodes;
    }

    public final StringProperty idProperty() {
        if (this.id == null) {
            this.id = new SimpleStringProperty((Object)this, "id");
        }
        return this.id;
    }

    public final void setId(String value) {
        this.idProperty().set((Object)value);
    }

    public final String getId() {
        return this.id != null ? (String)this.id.get() : null;
    }

    public final StringProperty styleProperty() {
        if (this.style == null) {
            this.style = new SimpleStringProperty((Object)this, "style");
        }
        return this.style;
    }

    public final void setStyle(String value) {
        this.styleProperty().set((Object)value);
    }

    public final String getStyle() {
        return this.style == null ? null : (String)this.style.get();
    }

    public String getTypeSelector() {
        return "Tab";
    }

    public ObservableList<String> getStyleClass() {
        return this.styleClass;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return TabPaneTab.getClassCssMetaData();
    }

    public Styleable getStyleableParent() {
        return this.getTabPane();
    }

    public final ObservableSet<PseudoClass> getPseudoClassStates() {
        return FXCollections.emptyObservableSet();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    private static class StyleableProperties {
        private static final CssMetaData<TabPaneTab, Number> ICON_WIDTH = new CssMetaData<TabPaneTab, Number>("-xtrip-icon-width", StyleConverter.getSizeConverter(), (Number)25.0){

            public boolean isSettable(TabPaneTab tab) {
                return tab.iconWidth == null || !tab.iconWidth.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(TabPaneTab tab) {
                return (StyleableProperty)tab.iconWidthProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<CssMetaData<TabPaneTab, Number>> styleables = new ArrayList<CssMetaData<TabPaneTab, Number>>(Control.getClassCssMetaData());
            styleables.add(ICON_WIDTH);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

