/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.util;

import com.gridnine.xtrip.common.incidents.IncidentsHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javafx.util.Pair;

public final class ActivityTracker {
    private static int LIMIT = 10;
    private static final List<Pair<String, String>> ITEMS = new ArrayList<Pair<String, String>>(LIMIT);

    public static synchronized void addItem(String function, String parameters) {
        Iterator<Pair<String, String>> it = ITEMS.iterator();
        while (it.hasNext()) {
            Pair<String, String> pair = it.next();
            if (!function.equals(pair.getKey()) || !parameters.equals(pair.getValue())) continue;
            it.remove();
        }
        if (ITEMS.size() == LIMIT) {
            ITEMS.remove(0);
        }
        ITEMS.add((Pair<String, String>)new Pair((Object)function, (Object)parameters));
    }

    public static synchronized void enrichException(Throwable error) {
        if (ITEMS.isEmpty()) {
            return;
        }
        StackTraceElement[] elements = new StackTraceElement[ITEMS.size()];
        for (int i = elements.length - 1; i >= 0; --i) {
            Pair<String, String> pair = ITEMS.get(i);
            elements[i] = IncidentsHelper.getContextStackTraceElement((String)((String)pair.getKey()), (String)((String)pair.getValue()));
        }
        IncidentsHelper.addStackTraceElement((Throwable)error, (StackTraceElement[])elements);
    }

    private ActivityTracker() {
    }
}

