/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.util;

import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.scene.Node;
import javafx.util.Duration;

public class ObservableMutex {
    private final ReentrantLock lock = new ReentrantLock(true);
    private final ReadOnlyBooleanWrapper acquiredProperty = new ReadOnlyBooleanWrapper((Object)this, "acquired");

    public static ObservableMutex lookup(Node node) {
        return (ObservableMutex)UiUtil.lookupProperty(node, ObservableMutex.class.getName());
    }

    public ReadOnlyBooleanProperty acquiredProperty() {
        return this.acquiredProperty.getReadOnlyProperty();
    }

    public boolean isAcquired() {
        return this.lock.isLocked();
    }

    public void acquire() throws InterruptedException {
        try {
            this.acquire(Duration.INDEFINITE);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    public void acquire(Duration timeout) throws InterruptedException, TimeoutException {
        Objects.requireNonNull(timeout, "timeout can't be null");
        if (timeout == Duration.UNKNOWN || timeout.toMillis() <= 0.0) {
            throw new IllegalArgumentException("timeout should be positive");
        }
        if (this.lock.isHeldByCurrentThread()) {
            return;
        }
        if (!this.lock.tryLock((long)timeout.toMillis(), TimeUnit.MILLISECONDS)) {
            throw new TimeoutException();
        }
        try {
            FxUtil.waitForFxThread(() -> this.acquiredProperty.set(this.lock.isLocked()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void release() {
        if (this.lock.isHeldByCurrentThread()) {
            this.lock.unlock();
            try {
                FxUtil.waitForFxThread(() -> this.acquiredProperty.set(this.lock.isLocked()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

