/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.correspondence.entity.actions.dialogs;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.BooleanValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.ibecorp.correspondence.entity.tasks.AddAttachmentsToProductTask;
import com.gridnine.xtrip.client.fx.ibecorp.l10n.Messages;
import com.gridnine.xtrip.client.fx.ibecorp.model.correspondence.AddAttachmentsToProductPane;
import com.gridnine.xtrip.client.fx.ibecorp.model.correspondence.AddAttachmentsToProductPaneController;
import com.gridnine.xtrip.client.fx.ibecorp.model.correspondence.HotelProductVM;
import com.gridnine.xtrip.client.fx.ibecorp.model.correspondence.IssueAttachmentVM;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.system.Document;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.ObjectProperty;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class AddAttachmentsToProductDialog {
    private final Control source;
    private final EntityContainer<BookingFile> bookingFile;
    private final List<HotelProduct> products;
    private final List<EntityReference<Document>> attachments;

    public AddAttachmentsToProductDialog(Control source, EntityContainer<BookingFile> bookingFile, List<HotelProduct> products, List<EntityReference<Document>> attachments) {
        this.source = source;
        this.bookingFile = bookingFile;
        this.products = products;
        this.attachments = attachments;
    }

    public void showDialog() {
        FxUtil.submitToFxThread(this::show);
    }

    private void show() {
        final AddAttachmentsToProductPane body = this.createBody();
        Dialog dialog = new Dialog();
        dialog.setTitle(Messages.AddAttachmentsToProduct).setAutoClose(false).setExpandToParent(false).setBody((Node)body).addButton(DialogButtonStyle.DECLINE, () -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, () -> this.runTask(dialog, body), (BooleanExpression)new BooleanBinding(){
            {
                BooleanValueWidgetColumn productsColumn = (BooleanValueWidgetColumn)body.getProductsNode().getColumn("selected");
                BooleanValueWidgetColumn attachmentsColumn = (BooleanValueWidgetColumn)body.getAttachmentsNode().getColumn("selected");
                this.bind((Observable[])IntStream.range(0, body.getProductsNode().getRowsCount()).mapToObj(arg_0 -> ((BooleanValueWidgetColumn)productsColumn).getWidget(arg_0)).map(BooleanValueWidget::valueProperty).toArray(ObjectProperty[]::new));
                this.bind((Observable[])IntStream.range(0, body.getAttachmentsNode().getRowsCount()).mapToObj(arg_0 -> ((BooleanValueWidgetColumn)attachmentsColumn).getWidget(arg_0)).map(BooleanValueWidget::valueProperty).toArray(ObjectProperty[]::new));
            }

            protected boolean computeValue() {
                return body.getProductsNode().getRowsData().stream().filter(HotelProductVM::isSelected).count() == 1L && body.getAttachmentsNode().getRowsData().stream().anyMatch(IssueAttachmentVM::isSelected);
            }
        }).setOnCloseRequest(() -> ((Dialog)dialog).close()).show((Node)this.source);
    }

    private AddAttachmentsToProductPane createBody() {
        AddAttachmentsToProductPane body = new AddAttachmentsToProductPane(false);
        body.getProductsNode().setControlButtonsAvailability(ControlsPane.NONE);
        body.getAttachmentsNode().setControlButtonsAvailability(ControlsPane.NONE);
        AddAttachmentsToProductPaneController controller = new AddAttachmentsToProductPaneController(body, false);
        controller.getProducts().readData(this.products.stream().map(prod -> {
            HotelProductVM productVM = new HotelProductVM();
            productVM.setProductTitle(BookingHelper.generateShortProductName((BaseProduct)prod));
            productVM.setProductUid(prod.getUid());
            return productVM;
        }).collect(Collectors.toList()));
        controller.getAttachments().readData(this.attachments.stream().map(attachment -> {
            IssueAttachmentVM attachmentVM = new IssueAttachmentVM();
            attachmentVM.setAttachmentTitle(attachment.getCaption());
            attachmentVM.setAttachmentUid(attachment.getUid());
            return attachmentVM;
        }).collect(Collectors.toList()));
        return body;
    }

    private void runTask(Dialog dialog, AddAttachmentsToProductPane body) {
        String productUid = body.getProductsNode().getRowsData().stream().filter(HotelProductVM::isSelected).map(HotelProductVM::getProductUid).findFirst().get();
        List attachmentsUids = body.getAttachmentsNode().getRowsData().stream().filter(IssueAttachmentVM::isSelected).map(IssueAttachmentVM::getAttachmentUid).collect(Collectors.toList());
        List<EntityReference<Document>> attachments = this.attachments.stream().filter(attachment -> attachmentsUids.contains(attachment.getUid())).collect(Collectors.toList());
        Notifications.get().enqueueAsyncTask((ClientTask)new AddAttachmentsToProductTask(this.bookingFile, productUid, attachments));
        dialog.close();
    }
}

