/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.correspondence.entity.handlers;

import com.gridnine.xtrip.client.fx.core.lib.components.CustomTextArea;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CustomWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.client.fx.ibecorp.model.correspondence.IssuePostVM;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.system.BaseFileDocument;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import javafx.geometry.Pos;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.web.WebView;

public class IssuePostWidget
extends CustomWidget<IssuePostVM> {
    private final VBox panel;
    private final ViewState viewState = new ViewState();
    private String caption = "";

    public IssuePostWidget(boolean ro) {
        this.viewState.setReadonly(ro);
        this.getStyleClass().add((Object)"issue-post-widget");
        this.panel = new VBox();
        this.getChildren().add((Object)this.panel);
    }

    String getCaption() {
        return this.caption;
    }

    public void setFieldName(String value) {
    }

    public ViewState getViewState() {
        return this.viewState;
    }

    public void readData(final IssuePostVM model) {
        boolean isSubagent;
        this.caption = model.getHotelEmail() != null ? this.caption + model.getHotelEmail() : (!TextUtil.isBlank((String)model.getAuthor()) ? model.getAuthor() : "");
        if (model.getDate() != null) {
            if (!TextUtil.isBlank((String)this.caption)) {
                this.caption = this.caption + " \u2014 ";
            }
            this.caption = this.caption + (String)StandardRenderers.DATE_TIME.apply((Object)model.getDate());
        }
        boolean bl = isSubagent = !model.isClient();
        if (isSubagent) {
            this.panel.setAlignment(Pos.TOP_RIGHT);
        }
        ArrayList<Object> nodes = new ArrayList<Object>();
        if (!TextUtil.isBlank((String)model.getPost())) {
            if (model.isHtml()) {
                WebView webView = new WebView();
                webView.setContextMenuEnabled(false);
                if (isSubagent) {
                    webView.getEngine().setUserStyleSheetLocation(((Object)((Object)this)).getClass().getResource("correspondence-subagent-web-view.css").toString());
                } else {
                    webView.getEngine().setUserStyleSheetLocation(((Object)((Object)this)).getClass().getResource("correspondence-client-web-view.css").toString());
                }
                webView.getEngine().loadContent(model.getPost());
                webView.setMaxWidth(600.0);
                webView.setPrefHeight(300.0);
                nodes.add(webView);
            } else {
                nodes.add(new CustomTextArea(){
                    {
                        this.setEditable(false);
                        this.setWrapText(true);
                        this.setMinHeight(Double.NEGATIVE_INFINITY);
                        this.setText(model.getPost());
                        if (isSubagent) {
                            this.setStyle("-fx-background-color: #dbf4fd; -fx-padding: 0.5em 1em");
                        } else {
                            this.setStyle("-fx-background-color: bisque; -fx-padding: 0.5em 1em");
                        }
                        IssuePostWidget.this.panel.widthProperty().addListener((s, o, n) -> {
                            double maxWidth = n.doubleValue() * 0.7;
                            Text text = new Text(this.getText());
                            text.setFont(this.getFont());
                            double textWidth = text.getLayoutBounds().getWidth();
                            double newMaxWidth = Math.min(maxWidth, textWidth) * 1.06 + 29.0;
                            text.setWrappingWidth(newMaxWidth);
                            double height = text.getLayoutBounds().getHeight();
                            double newPrefHeight = height * 1.06 + 19.0;
                            FxUtil.submitToFxThread(() -> {
                                this.setMaxWidth(newMaxWidth);
                                this.setPrefHeight(newPrefHeight);
                            });
                        });
                    }
                });
            }
        }
        if (model.getAttachments() != null) {
            for (EntityReference docRef : model.getAttachments()) {
                EntityBoxWidget widget = new EntityBoxWidget(BaseFileDocument.class, true);
                widget.setValue(docRef);
                nodes.add(widget);
            }
        }
        this.panel.getChildren().setAll(nodes);
    }

    public void writeData(IssuePostVM model) {
    }

    public boolean isDataChanged() {
        return false;
    }
}

