/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.dicts;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.registry.basic.Renderer;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.ibecorp.dicts.RailwayServiceClassControllerInterceptor;
import com.gridnine.xtrip.client.fx.ibecorp.l10n.Messages;
import com.gridnine.xtrip.client.fx.model.dict.RailwayServiceClassAvailableTrainsNumbersVM;
import com.gridnine.xtrip.client.fx.model.dict.RailwayServiceClassPanel;
import com.gridnine.xtrip.client.fx.model.dict.RailwayServiceClassPanelController;
import com.gridnine.xtrip.client.fx.model.dict.RailwayServiceClassPanelVM;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.BaseDictHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.DictHandlersHelper;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.ibecorp.railway.dict.RailwayServiceClass;
import com.gridnine.xtrip.common.model.ibecorp.railway.dict.RailwayServiceClassReference;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class RailwayServiceClassHandler
extends BaseDictHandler<RailwayServiceClassPanel, RailwayServiceClass, RailwayServiceClassPanelVM> {
    protected void configureStandardListParameters(DictListParameters params) {
        params.getColumns().add(DictHandlersHelper.COL_CODE);
        params.getColumns().add(DictHandlersHelper.COL_TRANSLATIONS);
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), (String)RailwayServiceClass.Property.carrier.name(), (String)Messages.Carrier, (Renderer)StandardRenderers.GENERIC));
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), (String)RailwayServiceClass.Property.serviceClass.name(), (String)Messages.ServiceClass, (Renderer)StandardRenderers.GENERIC));
    }

    protected void configureController(List<BiConsumer<RailwayServiceClass, RailwayServiceClassPanelVM>> toVM, List<BiConsumer<RailwayServiceClassPanelVM, RailwayServiceClass>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new RailwayServiceClassControllerInterceptor());
        toVM.add((model, vm) -> {
            vm.getMain().setCode(model.getCode());
            vm.getMain().setServiceClass(model.getServiceClass());
            vm.getMain().setCarrier(model.getCarrier());
            vm.getMain().getServices().addAll(model.getServices());
            vm.getMain().getAvailableTrainsNumbers().addAll(model.getAvailableTrainsNumbers().stream().map(num -> {
                RailwayServiceClassAvailableTrainsNumbersVM res = new RailwayServiceClassAvailableTrainsNumbersVM();
                res.setNumber(num);
                return res;
            }).collect(Collectors.toList()));
            DictHandlersHelper.translationsToVM((Map)model.getTranslations(), (List)vm.getTranslations().getContent());
        });
        fromVM.add((vm, model) -> {
            model.setCode(StringUtils.trim((String)vm.getMain().getCode()));
            model.setServiceClass(vm.getMain().getServiceClass());
            model.setCarrier(vm.getMain().getCarrier());
            model.getServices().clear();
            model.getServices().addAll(vm.getMain().getServices());
            model.getAvailableTrainsNumbers().clear();
            model.getAvailableTrainsNumbers().addAll(vm.getMain().getAvailableTrainsNumbers().stream().map(num -> num.getNumber()).collect(Collectors.toList()));
            DictHandlersHelper.translationsFromVM((List)vm.getTranslations().getContent(), (Map)model.getTranslations());
        });
    }

    public String format(RailwayServiceClass dict) {
        return dict.getCode();
    }

    public Class<RailwayServiceClass> getDictType() {
        return RailwayServiceClass.class;
    }

    public DictionaryReference<RailwayServiceClass> createReference(String code) {
        return new RailwayServiceClassReference(code);
    }

    protected RailwayServiceClassPanelVM createVM() {
        return new RailwayServiceClassPanelVM();
    }

    protected ViewController<RailwayServiceClassPanel, RailwayServiceClassPanelVM> createController() {
        return new RailwayServiceClassPanelController(false);
    }
}

