/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.entity.actions;

import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.CompactNavigatorWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.ibecorp.entity.tasks.dialog.CertificateOfCompletedFlightDialog;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceController;
import com.gridnine.xtrip.client.fx.standard.entity.actions.receipts.ListReceiptsAction;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceProduct;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class CertificateOfCompletedFlightAction
implements ListReceiptsAction {
    public String getId() {
        return "certificate-of-completed-flight";
    }

    public boolean isEnabled(RootEntityPane<?, ?> context) {
        DataTransferPackage dtp = context.getData();
        if (dtp == null || dtp.getContainer() == null) {
            return false;
        }
        List<BaseProduct> products = this.getSuitableProducts((BookingFile)dtp.getContainer().getEntity());
        return !products.isEmpty();
    }

    public void execute(Control source, RootEntityPane<?, ?> context, boolean alt) {
        DataTransferPackage dtp = context.getData();
        BookingFile bf = (BookingFile)dtp.getContainer().getEntity();
        List<BaseProduct> products = this.getSuitableProducts(bf);
        Notifications.get().submitTask(() -> {
            Map<BaseProduct, EntityReference<BookingFile>> products2Bookings = products.stream().collect(Collectors.toMap(obj -> obj, obj -> dtp.getContainer().toReference()));
            Node selectedView = ((CompactNavigatorWidget)((BookingFileSpaceController)context.getEditor().getProperties().get((Object)"controller")).getProductsFull().getView().getContent()).getSelectedView();
            String selectedProductUid = (String)selectedView.getProperties().get((Object)"model-uid");
            CertificateOfCompletedFlightDialog certificateOfCompletedFlightDialog = new CertificateOfCompletedFlightDialog(source, products2Bookings, selectedProductUid);
            FxUtil.submitToFxThread(certificateOfCompletedFlightDialog::showDialog);
        }, context.getMutex());
    }

    public String getName() {
        return Messages.Certificate_of_completed_flight;
    }

    private List<BaseProduct> getSuitableProducts(BookingFile bf) {
        ArrayList<BaseProduct> result = new ArrayList<BaseProduct>();
        if (bf == null) {
            return result;
        }
        return bf.getReservations().stream().flatMap(r -> r.getProducts().stream().filter(baseProduct -> baseProduct instanceof AdditionalServiceProduct)).collect(Collectors.toList());
    }
}

