/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityAction;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ClientSettings;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.ibecorp.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.model.ShipmentSpace;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.fx.rpc.service.AssetService;
import com.gridnine.xtrip.common.fx.rpc.service.IntegrationBusRpcService;
import com.gridnine.xtrip.common.ibecorp.model.IBusSbisContextKeys;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.assets.SysLogItem;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.ibecorp.sbis.SbisIntegrationSettings;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.standard.helpers.SysLogHelper;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javafx.scene.Scene;
import javafx.scene.control.Control;
import javafx.stage.DirectoryChooser;
import org.apache.commons.io.FileUtils;

public class ExportShipmentToSbisAction
implements RootEntityAction {
    public ActionIcon getIcon(RootEntityPane<?, ?> context) {
        return StandardActionIcons.EMPTY;
    }

    public double getWeight() {
        return 31.0;
    }

    public boolean isAvailable(RootEntityPane<?, ?> context) {
        return context.getEditor() instanceof ShipmentSpace && context.isLastVersion() && Prefetched.getData().isSbisIntegrationEnabled();
    }

    public boolean isEnabled(RootEntityPane<?, ?> context) {
        return true;
    }

    public void execute(Control source, RootEntityPane<?, ?> context, boolean alt) {
        DataTransferPackage dtp = context.getData();
        Notifications.get().enqueueAsyncTask((ClientTask)new ExportShipmentToSbisTask((EntityContainer<Shipment>)dtp.getContainer(), context.getEditor().getScene(), alt));
    }

    public String getId() {
        return "export-shipment-to-sbis";
    }

    static class ExportShipmentToSbisTask
    extends ClientTask {
        private final EntityContainer<Shipment> shipment;
        private final boolean alt;
        private final Scene scene;

        public ExportShipmentToSbisTask(EntityContainer<Shipment> shipment, Scene scene, boolean alt) {
            this.shipment = shipment;
            this.alt = alt;
            this.scene = scene;
        }

        protected void execute() throws Exception {
            File dir;
            HashMap<String, EntityReference> data = new HashMap<String, EntityReference>();
            EntityReference shipmentRef = this.shipment.toReference();
            data.put(IBusSbisContextKeys.SHIPMENT_REFERENCE.name(), shipmentRef);
            HashSet<String> keys = new HashSet<String>();
            keys.add(IBusSbisContextKeys.FILES_TO_EXPORT.name());
            keys.add(IBusSbisContextKeys.INTEGRATION_SETTINGS.name());
            Map result = ((IntegrationBusRpcService)RpcServiceManager.get().getService(IntegrationBusRpcService.class)).processRouteSync(ServiceInvocationContext.get(), "ibecorp:sbis:export-shipment", data, keys);
            List docs = (List)result.get(IBusSbisContextKeys.FILES_TO_EXPORT.name());
            if (this.alt) {
                FxUtil.submitToFxThread(() -> {
                    File selectedDirectory;
                    DirectoryChooser dc = new DirectoryChooser();
                    dc.setTitle(com.gridnine.xtrip.client.fx.core.l10n.Messages.General_Choose_Directory);
                    if (dc.getInitialDirectory() == null) {
                        File file = ClientSettings.get().getFileChooserDirectory();
                        if (UiUtil.isFileValid((File)file) && file.isDirectory()) {
                            dc.setInitialDirectory(file);
                        } else {
                            dc.setInitialDirectory(Environment.getDataFolder());
                        }
                    }
                    if ((selectedDirectory = dc.showDialog(this.scene.getWindow())) != null) {
                        Notifications.get().submitTask(() -> {
                            ClientSettings.get().setFileChooserDirectory(selectedDirectory);
                            ClientSettings.get().save();
                            docs.forEach(doc -> {
                                try {
                                    String name = TextUtil.normalizeFileName((String)doc.getName());
                                    File file = new File(selectedDirectory, name);
                                    FileUtils.writeByteArrayToFile((File)file, (byte[])doc.getContent());
                                    this.audit(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u043b\u043e\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0444\u0430\u0439\u043b {0}", (Object[])new Object[]{file.getAbsolutePath()}), (EntityReference<Shipment>)shipmentRef);
                                }
                                catch (IOException e) {
                                    Notifications.get().showMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u043b\u043e\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0444\u0430\u0439\u043b", (Throwable)e, (Object[])new Object[0])});
                                }
                            });
                        }, "\u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u0443\u0435\u043c \u0444\u0430\u0439\u043b\u044b \u0432 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u0443\u044e \u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u044e");
                    }
                });
                return;
            }
            SbisIntegrationSettings settings = (SbisIntegrationSettings)result.get(IBusSbisContextKeys.INTEGRATION_SETTINGS.name());
            String pathDir = settings.getGeneralSettings().getExportDirectory();
            EntityReference agent = Prefetched.getData().getCurrentAgentData().getAgent();
            EntityContainer currentUserCtr = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), agent);
            if (currentUserCtr != null && currentUserCtr.getEntity() != null && !TextUtil.isBlank((String)((Person)currentUserCtr.getEntity()).getExportDirectorySbis())) {
                pathDir = ((Person)currentUserCtr.getEntity()).getExportDirectorySbis();
            }
            if (!(dir = new File(pathDir)).exists() && !dir.mkdirs()) {
                throw Xeption.forEndUser((String)L10n.replace((String)Messages.ExportToSbis_UnableToCreateDirectory, (Object[])new Object[]{pathDir}), (Object[])new Object[0]);
            }
            for (Document doc : docs) {
                String name = TextUtil.normalizeFileName((String)doc.getName());
                File file = new File(dir, name);
                FileUtils.writeByteArrayToFile((File)file, (byte[])doc.getContent());
                this.audit(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d \u0444\u0430\u0439\u043b {0}", (Object[])new Object[]{file.getAbsolutePath()}), (EntityReference<Shipment>)shipmentRef);
            }
            boolean saveWithCheckPoint = !MiscUtil.equals((Object)"Export SBIS", (Object)this.shipment.getVersionInfo().getVersionNotes());
            this.shipment.getVersionInfo().setDataSource("fx-client");
            this.shipment.getVersionInfo().setVersionNotes("Export SBIS");
            ((Shipment)this.shipment.getEntity()).setExportedToSbis(true);
            ((Shipment)this.shipment.getEntity()).setLastExportToSbisDate(new Date());
            ((EntityService)RpcServiceManager.get().getService(EntityService.class)).save(ServiceInvocationContext.get(), this.shipment, null, saveWithCheckPoint);
            EventBus.get().publishAsync((Event)new EntityModificationEvent(null, new EntityModification(shipmentRef, EntityModification.ModificationType.CHANGE)));
        }

        private void audit(Message message, EntityReference<Shipment> shipmentRef) {
            try {
                SysLogItem sysLogItem = SysLogHelper.newAuditItem(shipmentRef, (String)"\u044d\u043a\u0441\u043f\u043e\u0440\u0442 \u0432 \u0421\u0411\u0418\u0421", (Message)message);
                ((AssetService)RpcServiceManager.get().getService(AssetService.class)).save(ServiceInvocationContext.get(), (BaseAsset)sysLogItem);
            }
            catch (Exception e) {
                Notifications.get().showMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0437\u0430\u043f\u0438\u0441\u044c \u0432 \u043b\u043e\u0433", (Throwable)e, (Object[])new Object[0])});
            }
        }

        protected String getTitle() {
            return Messages.ExportingToSbis;
        }
    }
}

