/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.entity.actions;

import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.standard.entity.actions.RollbackVersionEntityActionConfigurator;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.system.RollbackVersionsSettings;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.Objects;
import java.util.function.Consumer;

public class IbecorpRollbackVersionEntityActionConfigurator
implements RollbackVersionEntityActionConfigurator {
    public boolean isEnabled(Class<?> entityClass, EntityContainer<?> versionCtr) {
        RollbackVersionsSettings rollbackVersionsSettings;
        if (Shipment.class.isAssignableFrom(entityClass)) {
            return false;
        }
        if (BookingFile.class.isAssignableFrom(entityClass) && (rollbackVersionsSettings = Prefetched.getData().getRollbackVersionsSettings()) != null && rollbackVersionsSettings.isDisableBookingFileVersionsRollback()) {
            return !this.hasRelatedShipment((BookingFile)versionCtr.getEntity());
        }
        return true;
    }

    public boolean isEnabled(EntityContainer<?> versionCtr, Consumer<String> messageConsumer) {
        RollbackVersionsSettings rollbackVersionsSettings;
        if (versionCtr.getEntity() instanceof BookingFile && (rollbackVersionsSettings = Prefetched.getData().getRollbackVersionsSettings()) != null && rollbackVersionsSettings.isDisableBookingFileVersionsRollback()) {
            try {
                boolean hasRelatedShipment;
                EntityService service = (EntityService)RpcServiceManager.get().getService(EntityService.class);
                EntityContainer actualCtr = service.load(ServiceInvocationContext.get(), BookingFile.class, versionCtr.getUid());
                if (actualCtr != null && (hasRelatedShipment = this.hasRelatedShipment((BookingFile)actualCtr.getEntity()))) {
                    messageConsumer.accept(Messages.Couldnt_restore_version_Booking_file_has_related_shipment);
                    return false;
                }
            }
            catch (Exception e) {
                ErrorHandler.handle((Throwable)e);
            }
        }
        return true;
    }

    private boolean hasRelatedShipment(BookingFile bookingFile) {
        return bookingFile.getReservations().stream().flatMap(reservation -> reservation.getProducts().stream()).flatMap(product -> product.getFopDetalizations().values().stream()).flatMap(fd -> fd.getComponents().stream()).map(FopComponent::getShipment).anyMatch(Objects::nonNull);
    }
}

