/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityAction;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.ibecorp.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.model.ShipmentSpace;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.ibecorp.rpc.IbecorpModelService;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.awt.Desktop;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javafx.scene.control.Control;
import org.apache.commons.io.FilenameUtils;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class RegenerateShipmentRegistryAction
implements RootEntityAction {
    public static final File destDir = new File(Environment.getTempFolder(), "report-registries");

    public ActionIcon getIcon(RootEntityPane<?, ?> context) {
        return StandardActionIcons.EMPTY;
    }

    public double getWeight() {
        return 29.0;
    }

    public boolean isAvailable(RootEntityPane<?, ?> context) {
        return context.getEditor() instanceof ShipmentSpace && context.isLastVersion() && Prefetched.getData().isSbisIntegrationEnabled();
    }

    public boolean isEnabled(RootEntityPane<?, ?> context) {
        return true;
    }

    public void execute(Control source, RootEntityPane<?, ?> context, boolean alt) {
        DataTransferPackage dtp = context.getData();
        Notifications.get().enqueueAsyncTask((ClientTask)new RegenerateShipmentRegistryTask((EntityContainer<Shipment>)dtp.getContainer()));
    }

    public String getId() {
        return "regenerate-shipment-registry";
    }

    static class RegenerateShipmentRegistryTask
    extends ClientTask {
        private final EntityContainer<Shipment> shipment;

        public RegenerateShipmentRegistryTask(EntityContainer<Shipment> shipment) {
            this.shipment = shipment;
        }

        protected void execute() throws Exception {
            if (!Desktop.isDesktopSupported()) {
                Notifications.get().showMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.BatchPrintingIsNotAvailable, (Object[])new Object[0])});
                return;
            }
            IbecorpModelService.ReportRegistryData data = ((IbecorpModelService)RpcServiceManager.get().getService(IbecorpModelService.class)).getReportRegistryData(ServiceInvocationContext.get(), this.shipment.toReference());
            if (data == null) {
                throw Xeption.forEndUser((String)L10n.replace((String)Messages.UnableToLoadRegistry, (Object[])new Object[]{((Shipment)this.shipment.getEntity()).toString()}), (Object[])new Object[0]);
            }
            if (data.isRegistryNotConfigured()) {
                throw Xeption.forEndUser((String)"\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u0440\u0435\u0435\u0441\u0442\u0440\u043e\u0432 \u0434\u043b\u044f \u043a\u043b\u0438\u0435\u043d\u0442\u0430 {0} \u043d\u0435 \u0441\u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u043e.", (Object[])new Object[]{((Shipment)this.shipment.getEntity()).getCustomer()});
            }
            if (!destDir.exists()) {
                destDir.mkdirs();
            }
            XSSFWorkbook xssfWorkbook = new XSSFWorkbook((InputStream)new ByteArrayInputStream(data.getContent()));
            XSSFSheet sheet = xssfWorkbook.getSheet("MOM");
            int lastRowNumber = sheet.getLastRowNum();
            XSSFRow row = sheet.createRow(lastRowNumber + 1);
            row.createCell(0).setCellValue("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430");
            row.createCell(1).setCellValue("filename");
            row.createCell(2).setCellValue(new File(destDir, ((Shipment)this.shipment.getEntity()).getNumber() + ".xlsx").getAbsolutePath());
            String fileName = FilenameUtils.getBaseName((String)data.getFileName());
            String extension = FilenameUtils.getExtension((String)data.getFileName());
            File tempFile = File.createTempFile(fileName, "." + extension);
            try (FileOutputStream fs = new FileOutputStream(tempFile);){
                xssfWorkbook.write((OutputStream)fs);
            }
            Desktop desktop = Desktop.getDesktop();
            if (desktop == null) {
                return;
            }
            desktop.open(tempFile);
        }

        protected String getTitle() {
            return Messages.RegeneratingRegistry;
        }
    }
}

