/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.booking;

import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.ibecorp.model.booking.BookingFileCustomerContactsEmailVM;
import com.gridnine.xtrip.client.fx.ibecorp.model.booking.BookingFileCustomerContactsGridPanel;
import com.gridnine.xtrip.client.fx.ibecorp.model.booking.BookingFileCustomerContactsGridPanelController;
import com.gridnine.xtrip.client.fx.ibecorp.model.booking.BookingFileCustomerKeyContactPanel;
import com.gridnine.xtrip.client.fx.ibecorp.model.booking.BookingFileCustomerKeyContactPanelController;
import com.gridnine.xtrip.client.fx.ibecorp.model.booking.BookingFileCustomerKeyContactPanelVM;
import com.gridnine.xtrip.client.fx.ibecorp.model.booking.BookingFileCustomerMainPanel;
import com.gridnine.xtrip.client.fx.ibecorp.model.booking.BookingFileCustomerPanel;
import com.gridnine.xtrip.client.fx.ibecorp.model.booking.BookingFileCustomerPanelController;
import com.gridnine.xtrip.client.fx.ibecorp.model.booking.BookingFileCustomerPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.ContactPhonesTableVM;
import com.gridnine.xtrip.client.fx.standard.helpers.ContactsPaneHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.ListParametersHelper;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonCommunication;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.scene.Node;

public class CustomerTileControllerInterceptor
extends ControllerInterceptor<BookingFileCustomerPanelVM, BookingFileCustomerPanelController> {
    static final List<CommunicationType> EMAIL_TYPES = Arrays.asList(CommunicationType.EMAIL);

    protected Class<BookingFileCustomerPanelController> getControllerClass() {
        return BookingFileCustomerPanelController.class;
    }

    protected void onCreate(BookingFileCustomerPanelController controller) {
        BookingFileCustomerPanel view = controller.getView();
        BookingFileCustomerContactsGridPanel contactsPanel = (BookingFileCustomerContactsGridPanel)view.getCommunicationsCard().getContent();
        ContactsPaneHelper.configurePhonesTable((TableWidget)contactsPanel.getPhoneNode(), null);
        ComboBoxWidgetColumn typeColumn = (ComboBoxWidgetColumn)contactsPanel.getEmailNode().getColumn("type");
        typeColumn.setItemsSupplier(() -> EMAIL_TYPES);
        EntityBoxWidget profileWidget = ((BookingFileCustomerMainPanel)view.getMainCard().getContent()).getProfileNode();
        profileWidget.setListParametersSupplier(() -> this.getPersonIndexListParameters((Node)view));
        profileWidget.setValueSelectionListener(idx -> {
            EntityReference ref = profileWidget.getValue();
            if (ref == null) {
                return;
            }
            if (contactsPanel.getPhoneNode().getRowsCount() > 0 && contactsPanel.getEmailNode().getRowsCount() > 0) {
                return;
            }
            Notifications.get().submitTask(() -> this.populateContacts((EntityReference<Person>)ref, contactsPanel), "\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445 \u043f\u043e\u043a\u0443\u043f\u0430\u0442\u0435\u043b\u044f.");
        });
        BookingFileCustomerKeyContactPanel keyContactPanel = (BookingFileCustomerKeyContactPanel)view.getKeyContactCard().getContent();
        EntityBoxWidget profileWidgetForKeyContact = keyContactPanel.getProfileNode();
        profileWidgetForKeyContact.setListParametersSupplier(() -> this.getPersonIndexListParameters((Node)view));
        profileWidgetForKeyContact.setValueSelectionListener(idx -> {
            EntityReference ref = profileWidgetForKeyContact.getValue();
            if (ref == null) {
                return;
            }
            Notifications.get().submitTask(() -> this.populateKeyContacts((EntityReference<Person>)ref, keyContactPanel), Messages.General_Data_loading);
        });
    }

    private IndexListParameters<Person, PersonIndex> getPersonIndexListParameters(Node node) {
        RootEntityPane rep = RootEntityPane.lookup((Node)node);
        EntityContainer bfCont = rep.getData().getContainer();
        EntityReference clientRef = ((BookingFile)bfCont.getEntity()).getCustomerProfile();
        IndexListParameters result = ControllerInterceptorsHelper.getPassengers((EntityReference)clientRef, null);
        ListParametersHelper.setColumns((IndexListParameters)result, (String[])new String[]{PersonIndex.Property.company.name()});
        return result;
    }

    private void populateContacts(EntityReference<Person> ref, BookingFileCustomerContactsGridPanel contactsPanel) throws Exception {
        EntityContainer ctr = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), ref);
        if (ctr == null) {
            return;
        }
        ArrayList<ContactPhonesTableVM> phones = new ArrayList<ContactPhonesTableVM>();
        ArrayList<ContactPhonesTableVM> emails = new ArrayList<ContactPhonesTableVM>();
        for (PersonCommunication cmm : ((Person)ctr.getEntity()).getCommunications()) {
            ContactPhonesTableVM vm;
            CommunicationType type = cmm.getType();
            if (type == null) continue;
            if (ContactsPaneHelper.PHONE_TYPES.contains(type)) {
                vm = new ContactPhonesTableVM();
                vm.setCityCode(cmm.getCityCode());
                vm.setCountryCode(cmm.getCountryCode());
                vm.setInternalNumber(cmm.getInternalNumber());
                vm.setPhoneNumber(cmm.getSense());
                vm.setNotes(cmm.getRemarks());
                vm.setType(cmm.getType());
                phones.add(vm);
                continue;
            }
            if (!EMAIL_TYPES.contains(type)) continue;
            vm = new BookingFileCustomerContactsEmailVM();
            vm.setAddress(cmm.getSense());
            vm.setNotes(cmm.getRemarks());
            vm.setType(cmm.getType());
            emails.add(vm);
        }
        if (phones.isEmpty() && emails.isEmpty()) {
            return;
        }
        FxUtil.submitToFxThread(() -> {
            BookingFileCustomerContactsGridPanelController controller = BookingFileCustomerContactsGridPanelController.forView((BookingFileCustomerContactsGridPanel)contactsPanel);
            if (contactsPanel.getPhoneNode().getRowsCount() == 0) {
                controller.getPhone().readData((Object)phones);
            }
            if (contactsPanel.getEmailNode().getRowsCount() == 0) {
                controller.getEmail().readData((Object)emails);
            }
        });
    }

    private void populateKeyContacts(EntityReference<Person> ref, BookingFileCustomerKeyContactPanel keyContactPanel) throws Exception {
        EntityContainer ctr = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), ref);
        if (ctr == null) {
            return;
        }
        BookingFileCustomerKeyContactPanelVM panelVM = new BookingFileCustomerKeyContactPanelVM();
        panelVM.setProfile(ref);
        for (PersonCommunication cmm : ((Person)ctr.getEntity()).getCommunications()) {
            CommunicationType type = cmm.getType();
            if (type == null) continue;
            if (ContactsPaneHelper.PHONE_TYPES.contains(type)) {
                panelVM.setPhone(cmm.getCountryCode() + cmm.getCityCode() + cmm.getSense());
                continue;
            }
            if (!EMAIL_TYPES.contains(type)) continue;
            panelVM.setEmail(cmm.getSense());
        }
        FxUtil.submitToFxThread(() -> {
            BookingFileCustomerKeyContactPanelController panelController = BookingFileCustomerKeyContactPanelController.forView((BookingFileCustomerKeyContactPanel)keyContactPanel);
            panelController.readData(panelVM);
        });
    }
}

