/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.booking.actions;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.ibecorp.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.BaseProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ProductActionContext;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.rpc.service.IntegrationBusRpcService;
import com.gridnine.xtrip.common.ibecorp.AirAllowingHelper;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.helper.SalesContextHandler;
import com.gridnine.xtrip.common.midoffice.model.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class VoidReservationAction
extends BaseProductAction<Product> {
    public double getWeight() {
        return 70.0;
    }

    protected String getName() {
        return Messages.VoidReservationInGds;
    }

    protected String getDescription() {
        return Messages.VoidReservationInGdsVerb;
    }

    protected boolean isSaveRequired() {
        return true;
    }

    protected boolean isEnabled(Product product) {
        return AirAllowingHelper.isReservationValidForUnsell((Reservation)product.getReservation());
    }

    protected void execute(ProductActionContext<Product> ctx) {
        Dialog.confirm((String)Messages.VoidReservationInGdsQuestion, () -> Notifications.get().submitTask(() -> {
            EntityContainer bfCtr = ctx.getRootPane().getData().getContainer();
            String productUid = ((Product)ctx.getSelectedProduct()).getUid();
            BaseProduct product = BookingHelper.findProduct((EntityContainer)bfCtr, (String)productUid);
            Reservation reservation = product.getReservation();
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put(IBusMidofficeContextKeys.BOOKING_FILE.name(), bfCtr);
            data.put(IBusMidofficeContextKeys.SALES_CONTEXT.name(), this.buildSalesContext(reservation));
            data.put(IBusMidofficeContextKeys.BOOKING_FILE_RESERVATIONS.name(), Collections.singletonList(reservation));
            Map resultData = ((IntegrationBusRpcService)((RpcServiceManager)Environment.getPublished(RpcServiceManager.class)).getService(IntegrationBusRpcService.class)).processRouteSync((ServiceInvocationContext)Environment.getPublished(ServiceInvocationContext.class), "ibecorp:booking:is-void-booking-allowed-route", data, Collections.singleton(IBusIbecorpContextKeys.IS_VOID_BOOKING_ALLOWED.name()));
            if (!Boolean.TRUE.equals(resultData.get(IBusIbecorpContextKeys.IS_VOID_BOOKING_ALLOWED.name()))) {
                Notifications.get().showMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.VoidReservationInGdsForbidden, (Object[])new Object[0])});
                return;
            }
            ((IntegrationBusRpcService)((RpcServiceManager)Environment.getPublished(RpcServiceManager.class)).getService(IntegrationBusRpcService.class)).processRouteSync((ServiceInvocationContext)Environment.getPublished(ServiceInvocationContext.class), "ibecorp:booking:void-booking-route", data);
            EventBus.get().publishAsync((Event)new EntityModificationEvent(null, new EntityModification(bfCtr.toReference(), EntityModification.ModificationType.CHANGE)));
        }, Messages.VoidReservationInGdsProcess));
    }

    private SalesContext buildSalesContext(Reservation reservation) {
        return SalesContextHandler.get().createSalesContext(reservation);
    }
}

