/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.organization;

import com.gridnine.xtrip.client.fx.core.entity.RootEntityEditorInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.organization.IbeOrganizationEditorInterceptor;
import com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.organization.IbeOrganizationFinanceDocumentSettingControllerInterceptor;
import com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.organization.OrganizationContactsTileHelper;
import com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.organization.OrganizationGeneralTileIbeHelper;
import com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.organization.OrganizationHotelContainerInterceptor;
import com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.organization.OrganizationHotelTileHelper;
import com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.organization.OrganizationIbeControllerInterceptor;
import com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.organization.OrganizationImagesTileHelper;
import com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.organization.OrganizationSiteTileHelper;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationSpaceVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.organization.OrganizationHandlerConfigurator;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.ibecorp.sap.SapOrganizationData;
import com.gridnine.xtrip.common.model.person.uidata.OrganizationUIData;
import com.gridnine.xtrip.common.model.profile.Organization;
import java.util.List;
import java.util.function.BiConsumer;

public class IbeOrganizationHandlerConfigurator
implements OrganizationHandlerConfigurator {
    public void configureController(List<BiConsumer<DataTransferPackage<Organization, OrganizationUIData>, OrganizationSpaceVM>> toVM, List<BiConsumer<OrganizationSpaceVM, DataTransferPackage<Organization, OrganizationUIData>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new OrganizationIbeControllerInterceptor());
        ControllersRegistry.register((ControllerInterceptor)new OrganizationHotelContainerInterceptor());
        ControllersRegistry.register((ControllerInterceptor)new IbeOrganizationFinanceDocumentSettingControllerInterceptor());
        toVM.add((dtp, vm) -> {
            Organization model = (Organization)dtp.getContainer().getEntity();
            OrganizationSiteTileHelper.toVM(model, vm.getSiteFull());
            OrganizationGeneralTileIbeHelper.toVM(model, vm.getMainFull());
            OrganizationContactsTileHelper.toVM(model, vm.getContactsFull());
            OrganizationHotelTileHelper.toVM(model, vm.getMainFull().getMain(), vm.getHotelFull());
            OrganizationImagesTileHelper.toVM(model, vm.getOtherParametersFull().getImages());
            vm.getOtherParametersFull().getAdditionalCard().setSirenaItinReceipts(model.isSirenaItinReceipts());
            vm.getOtherParametersFull().getAdditionalCard().setAtolSettings(model.getAtolSettings());
            vm.getOtherParametersFull().getAdditionalCard().setTimeZoneEx(model.getTimeZoneEx());
            SapOrganizationData sapSettings = model.getSapSettings();
            vm.getExternalSystemSynchronizationFull().getSapSync().getBasicParameters().setSapId(sapSettings.getSapId());
            vm.getExternalSystemSynchronizationFull().getSapSync().getBasicParameters().setSyncEnabled(sapSettings.isSyncEnabled());
            vm.getSettingsFull().getTravelPolicySettings().setTravelPolicy(model.getIbeTravelPolicy());
            vm.getSettingsFull().getNotificationSettingsCard().setNotificationSettings(model.getIbeNotificationSettings());
        });
        fromVM.add((vm, dtp) -> {
            Organization model = (Organization)dtp.getContainer().getEntity();
            OrganizationSiteTileHelper.fromVM(vm.getSiteFull(), model);
            OrganizationGeneralTileIbeHelper.fromVM(vm.getMainFull(), model);
            OrganizationContactsTileHelper.fromVM(vm.getContactsFull(), model);
            OrganizationHotelTileHelper.fromVM(vm.getMainFull().getMain(), vm.getHotelFull(), model);
            OrganizationImagesTileHelper.fromVM(vm.getOtherParametersFull().getImages(), model);
            model.setSirenaItinReceipts(vm.getOtherParametersFull().getAdditionalCard().isSirenaItinReceipts());
            model.setAtolSettings(vm.getOtherParametersFull().getAdditionalCard().getAtolSettings());
            model.setTimeZoneEx(vm.getOtherParametersFull().getAdditionalCard().getTimeZoneEx());
            model.getSapSettings().setSapId(vm.getExternalSystemSynchronizationFull().getSapSync().getBasicParameters().getSapId());
            model.getSapSettings().setSyncEnabled(vm.getExternalSystemSynchronizationFull().getSapSync().getBasicParameters().isSyncEnabled());
            model.setIbeTravelPolicy(vm.getSettingsFull().getTravelPolicySettings().getTravelPolicy());
            model.setIbeNotificationSettings(vm.getSettingsFull().getNotificationSettingsCard().getNotificationSettings());
        });
    }

    public void collectEditorInterceptors(List<RootEntityEditorInterceptor<Organization, OrganizationUIData>> editorInterceptors) {
        editorInterceptors.add(new IbeOrganizationEditorInterceptor());
    }
}

