/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.organization;

import com.gridnine.xtrip.client.fx.model.profile.OrganizationContactsPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationEmailVM;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;

public class OrganizationContactsTileHelper {
    private OrganizationContactsTileHelper() {
    }

    static void toVM(Organization model, OrganizationContactsPanelVM full) {
        ArrayList<Communication> emails = new ArrayList<Communication>();
        for (Communication cmm2 : model.getCommunications()) {
            if (cmm2.getType() != CommunicationType.EMAIL) continue;
            emails.add(cmm2);
        }
        VMHelper.transfer(emails, (Collection)full.getEmails(), cmm -> new OrganizationEmailVM(), (cmm, vm) -> {
            vm.setSendToHotel(cmm.isSendToHotel());
            vm.setSendFinDoc(cmm.isSendFinDoc());
        });
    }

    static void fromVM(OrganizationContactsPanelVM full, Organization model) {
        ArrayList communicationVMs = new ArrayList();
        communicationVMs.addAll(full.getPhones());
        communicationVMs.addAll(full.getEmails().stream().filter(vm1 -> !TextUtil.isBlank((String)vm1.getAddress()) || !TextUtil.isBlank((String)vm1.getNotes())).collect(Collectors.toList()));
        communicationVMs.addAll(full.getSites());
        VMHelper.transfer(communicationVMs, (Collection)model.getCommunications(), vm1 -> new Communication(), (vm1, cmm) -> {
            if (vm1 instanceof OrganizationEmailVM) {
                OrganizationEmailVM emailVM = (OrganizationEmailVM)vm1;
                cmm.setSendToHotel(emailVM.isSendToHotel());
                cmm.setSendFinDoc(emailVM.isSendFinDoc());
            }
        });
    }
}

