/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.sap;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.sap.SapLogDocumentControllerInterceptor;
import com.gridnine.xtrip.client.fx.ibecorp.model.sap.MessageVM;
import com.gridnine.xtrip.client.fx.ibecorp.model.sap.SapLogDocumentContainerCard;
import com.gridnine.xtrip.client.fx.ibecorp.model.sap.SapLogDocumentContainerCardController;
import com.gridnine.xtrip.client.fx.ibecorp.model.sap.SapLogDocumentContainerCardVM;
import com.gridnine.xtrip.client.fx.ibecorp.model.sap.SapLogDocumentGeneralPanelVM;
import com.gridnine.xtrip.client.fx.ibecorp.model.sap.SapLogDocumentTracePanelVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.ibecorp.sap.SapLogDocument;
import com.gridnine.xtrip.common.model.ibecorp.sap.SapLogDocumentIndex;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;

public class SapLogDocumentHandler
extends BaseRootEntityHandler<SapLogDocument, Void, SapLogDocumentContainerCardVM, SapLogDocumentContainerCard> {
    public Class<SapLogDocument> getEntityClass() {
        return SapLogDocument.class;
    }

    public Class<Void> getSupplementClass() {
        return Void.class;
    }

    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return SapLogDocumentIndex.class;
    }

    protected void configureController(List<BiConsumer<DataTransferPackage<SapLogDocument, Void>, SapLogDocumentContainerCardVM>> toVM, List<BiConsumer<SapLogDocumentContainerCardVM, DataTransferPackage<SapLogDocument, Void>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new SapLogDocumentControllerInterceptor());
        toVM.add((dtp, vm) -> {
            SapLogDocument model = (SapLogDocument)dtp.getContainer().getEntity();
            SapLogDocumentGeneralPanelVM generalVM = vm.getGeneral();
            generalVM.setIdReserve(model.getIdReserve());
            generalVM.setIdComplexReserve(model.getIdComplexReserve());
            generalVM.setStatus(model.getStatus());
            VMHelper.transfer((Collection)model.getLogContents(), (Collection)vm.getTrace(), item -> new SapLogDocumentTracePanelVM(), (item, itemVM) -> {
                if (item.getContent() != null) {
                    itemVM.setContent(new String(item.getContent()));
                }
                itemVM.setName(item.getType());
            });
            VMHelper.transfer((Collection)model.getMessages(), (Collection)vm.getMessages().getContent(), message -> {
                MessageVM result = new MessageVM();
                result.setType(message.getType() == null ? null : message.getType().toString());
                result.getDetails().setType(message.getType());
                result.getDetails().setDetails(message.getDetails());
                if (message.getMessage() != null) {
                    result.setMessage(message.getMessage().toString());
                    result.getDetails().setMessage(message.getMessage().toString());
                }
                return result;
            });
        });
    }

    protected ViewController<SapLogDocumentContainerCard, SapLogDocumentContainerCardVM> createSpaceController(boolean readonly) {
        return new SapLogDocumentContainerCardController(readonly);
    }

    protected SapLogDocumentContainerCardVM createVM() {
        return new SapLogDocumentContainerCardVM();
    }
}

