/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.security;

import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.model.AclAspectVariantData;
import com.gridnine.xtrip.common.fx.model.IbeAclAspectData;
import com.gridnine.xtrip.common.model.security.acl.IbeCorpAclAspectVariantsType;
import com.gridnine.xtrip.common.util.Identity;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

class AspectsDataHelper {
    static String getAspectName(String aspectUid) {
        for (IbeAclAspectData data : Prefetched.getData().getAvailableIbeAclAspects()) {
            if (!data.getUid().equals(aspectUid)) continue;
            return data.getName();
        }
        return null;
    }

    static String getVariantName(String aspectUid, String variantUid) {
        for (IbeAclAspectData data : Prefetched.getData().getAvailableIbeAclAspects()) {
            if (!data.getUid().equals(aspectUid)) continue;
            for (AclAspectVariantData variantData : data.getVariants()) {
                if (!variantData.getUid().equals(variantUid)) continue;
                return variantData.getName();
            }
        }
        return null;
    }

    static List<String> getVariantUids(String aspectUid) {
        for (IbeAclAspectData data : Prefetched.getData().getAvailableIbeAclAspects()) {
            if (!data.getUid().equals(aspectUid)) continue;
            return data.getVariants().stream().map(Identity::getUid).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    static boolean isExclusion(String aspectUid) {
        for (IbeAclAspectData data : Prefetched.getData().getAvailableIbeAclAspects()) {
            if (!data.getUid().equals(aspectUid)) continue;
            return data.getVariantsType() == IbeCorpAclAspectVariantsType.EXCLUSION;
        }
        return false;
    }

    private AspectsDataHelper() {
    }
}

