/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.site;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.site.RulesHolderControllerInterceptor;
import com.gridnine.xtrip.client.fx.ibecorp.l10n.Messages;
import com.gridnine.xtrip.client.fx.ibecorp.model.site.IBERulesHolderSpace;
import com.gridnine.xtrip.client.fx.ibecorp.model.site.IBERulesHolderSpaceController;
import com.gridnine.xtrip.client.fx.ibecorp.model.site.IBERulesHolderSpaceVM;
import com.gridnine.xtrip.client.fx.ibecorp.model.site.IBERulesTableVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.fx.model.RulesHolderUIData;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.dict.AirlineCard;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.RulesHolder;
import com.gridnine.xtrip.common.model.profile.RulesHolderIndex;
import com.gridnine.xtrip.common.model.profile.SalesPointAirlineInfo;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.rules.RuleSet;
import java.util.List;
import java.util.function.BiConsumer;

public class RulesHolderHandler
extends BaseRootEntityHandler<RulesHolder, RulesHolderUIData, IBERulesHolderSpaceVM, IBERulesHolderSpace> {
    public Class<RulesHolder> getEntityClass() {
        return RulesHolder.class;
    }

    public Class<RulesHolderUIData> getSupplementClass() {
        return RulesHolderUIData.class;
    }

    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return RulesHolderIndex.class;
    }

    protected void configureController(List<BiConsumer<DataTransferPackage<RulesHolder, RulesHolderUIData>, IBERulesHolderSpaceVM>> toVM, List<BiConsumer<IBERulesHolderSpaceVM, DataTransferPackage<RulesHolder, RulesHolderUIData>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new RulesHolderControllerInterceptor());
        toVM.add((dtp, vm) -> {
            RulesHolder model = (RulesHolder)dtp.getContainer().getEntity();
            vm.getSiteRulesFull().getSiteRules().setName(model.getName());
            VMHelper.copy((BaseEntity)model.getRuleSet(), (BaseEntity)vm.getRulesFull());
            vm.getOverview().setName(model.getName());
            vm.getAirlineInfosFull().getTable().clear();
            for (SalesPointAirlineInfo info : model.getAirlineInfos()) {
                IBERulesTableVM row = new IBERulesTableVM();
                row.setAirline(info.getAirline());
                row.setHint(info.getHint());
                for (AirlineCard card : info.getAcceptableCards()) {
                    row.getCardType().add(card.getVendor());
                }
                vm.getAirlineInfosFull().getTable().add(row);
            }
        });
        fromVM.add((vm, dtp) -> {
            RulesHolder model = (RulesHolder)dtp.getContainer().getEntity();
            model.setName(vm.getSiteRulesFull().getSiteRules().getName());
            if (model.getRuleSet() == null) {
                model.setRuleSet(new RuleSet());
            }
            VMHelper.copy((BaseEntity)vm.getRulesFull(), (BaseEntity)model.getRuleSet());
            model.getAirlineInfos().clear();
            for (IBERulesTableVM row : vm.getAirlineInfosFull().getTable()) {
                SalesPointAirlineInfo card = new SalesPointAirlineInfo();
                card.setAirline(row.getAirline());
                card.setHint(row.getHint());
                for (CardVendor cardVendor : row.getCardType()) {
                    AirlineCard airCard = new AirlineCard();
                    airCard.setVendor(cardVendor);
                    airCard.setCode(DictHelper.getDefaultCardCode((CardVendor)cardVendor));
                    card.getAcceptableCards().add(airCard);
                }
                model.getAirlineInfos().add(card);
            }
        });
    }

    protected ViewController<IBERulesHolderSpace, IBERulesHolderSpaceVM> createSpaceController(boolean readonly) {
        return new IBERulesHolderSpaceController(readonly);
    }

    protected IBERulesHolderSpaceVM createVM() {
        return new IBERulesHolderSpaceVM();
    }

    public String format(EntityContainer<RulesHolder> ctr) {
        return L10n.replace((String)Messages.SMRulesHolder_name, (Object[])new Object[]{((RulesHolder)ctr.getEntity()).getName() != null ? ((RulesHolder)ctr.getEntity()).getName() : Messages.No_Name_Site});
    }
}

