/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.site;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.ibecorp.entity.handlers.site.SMGeneralSettingsControllerInterceptor;
import com.gridnine.xtrip.client.fx.ibecorp.l10n.Messages;
import com.gridnine.xtrip.client.fx.ibecorp.model.site.SMCurrencyDisplaySettingsVM;
import com.gridnine.xtrip.client.fx.ibecorp.model.site.SMGeneralSettingsContainer;
import com.gridnine.xtrip.client.fx.ibecorp.model.site.SMGeneralSettingsContainerController;
import com.gridnine.xtrip.client.fx.ibecorp.model.site.SMGeneralSettingsContainerVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.ibecorp.sm.MultiLingualText;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMCurrencyDisplaySettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettingsIndex;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class SMGeneralSettingsHandler
extends BaseRootEntityHandler<SMGeneralSettings, Void, SMGeneralSettingsContainerVM, SMGeneralSettingsContainer> {
    public Class<SMGeneralSettings> getEntityClass() {
        return SMGeneralSettings.class;
    }

    public Class<Void> getSupplementClass() {
        return Void.class;
    }

    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return SMGeneralSettingsIndex.class;
    }

    protected void configureController(List<BiConsumer<DataTransferPackage<SMGeneralSettings, Void>, SMGeneralSettingsContainerVM>> toVM, List<BiConsumer<SMGeneralSettingsContainerVM, DataTransferPackage<SMGeneralSettings, Void>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new SMGeneralSettingsControllerInterceptor());
        toVM.add((dtp, vm) -> {
            SMGeneralSettings model = (SMGeneralSettings)dtp.getContainer().getEntity();
            vm.getGeneral().setSite(model.getSite());
            vm.getGeneral().setTimeZone(model.getTimeZone());
            vm.getGeneral().setDefaultLocale(model.getDefaultLocale());
            vm.getGeneral().setDefaultCountry(model.getDefaultCountry());
            vm.getGeneral().setDefaultSalesPoint(model.getDefaultSalesPoint());
            VMHelper.transfer((Collection)model.getAdditionalLocales(), (Collection)vm.getGeneral().getAdditionalLocales());
            vm.getGeneral().setPersonalCabinetEnabled(model.isPersonalCabinetEnabled());
            vm.getGeneral().setPersonalDataLink(model.getPersonalDataLink());
            vm.getCurrencyConverter().clear();
            vm.getCurrencyConverter().addAll(model.getDisplayCurrencies().stream().map(SMGeneralSettingsHandler::mapCurrencyDisplaySettingsToVM).collect(Collectors.toList()));
            vm.getGeneral().setDefaultPaymentType(model.getDefaultPaymentType());
            vm.getGeneral().setHideUnavailableServices(model.isHideUnavailableServices());
            vm.getGeneral().setGoogleMapsApiKey(model.getGoogleMapsApiKey());
            vm.getGeneral().setGeocoderApiToken(model.getGeocoderApiToken());
            vm.getGeneral().setGeocoderIwayGdsAccount(model.getGeocoderIwayGdsAccount());
            vm.getGeneral().setGeocoderApiTokenType(model.getGeocoderApiTokenType());
            if (model.getCalendarSettings().isSaturdayForbidden()) {
                vm.getBookingRestrictions().getBannedDays().add(Messages.Saturday);
            }
            if (model.getCalendarSettings().isSundayForbidden()) {
                vm.getBookingRestrictions().getBannedDays().add(Messages.Sunday);
            }
            vm.getBookingRestrictions().setDaysShift(Integer.valueOf(model.getCalendarSettings().getDaysShift()));
            vm.getBookingRestrictions().setBannedDates(this.datesToString(model.getCalendarSettings().getExcludedDates()));
            vm.getBookingRestrictions().setBannedEmail(this.emailsToString(model.getBannedEmail()));
            vm.getBookingRestrictions().setStopTime(model.getCalendarSettings().getStopTime());
            Locale currentLocale = LocaleHelper.getCurrentLocale();
            if (currentLocale != null) {
                switch (currentLocale.getLanguage()) {
                    case "ru": {
                        vm.getErrorMessage().getDefaultDialogErrorMessage().setRu(L10nStringHelper.getValue((L10nString)model.getDefaultDialogErrorMessage(), (Locale)currentLocale));
                        break;
                    }
                    case "en": {
                        vm.getErrorMessage().getDefaultDialogErrorMessage().setEn(L10nStringHelper.getValue((L10nString)model.getDefaultDialogErrorMessage(), (Locale)currentLocale));
                        break;
                    }
                    case "uk": {
                        vm.getErrorMessage().getDefaultDialogErrorMessage().setUk(L10nStringHelper.getValue((L10nString)model.getDefaultDialogErrorMessage(), (Locale)currentLocale));
                        break;
                    }
                    case "bg": {
                        vm.getErrorMessage().getDefaultDialogErrorMessage().setBg(L10nStringHelper.getValue((L10nString)model.getDefaultDialogErrorMessage(), (Locale)currentLocale));
                        break;
                    }
                    case "kz": {
                        vm.getErrorMessage().getDefaultDialogErrorMessage().setKz(L10nStringHelper.getValue((L10nString)model.getDefaultDialogErrorMessage(), (Locale)currentLocale));
                        break;
                    }
                    case "ka": {
                        vm.getErrorMessage().getDefaultDialogErrorMessage().setKa(L10nStringHelper.getValue((L10nString)model.getDefaultDialogErrorMessage(), (Locale)currentLocale));
                        break;
                    }
                    case "hy": {
                        vm.getErrorMessage().getDefaultDialogErrorMessage().setHy(L10nStringHelper.getValue((L10nString)model.getDefaultDialogErrorMessage(), (Locale)currentLocale));
                        break;
                    }
                    case "az": {
                        vm.getErrorMessage().getDefaultDialogErrorMessage().setAz(L10nStringHelper.getValue((L10nString)model.getDefaultDialogErrorMessage(), (Locale)currentLocale));
                    }
                }
            }
        });
        fromVM.add((vm, dtp) -> {
            SMGeneralSettings model = (SMGeneralSettings)dtp.getContainer().getEntity();
            model.setTimeZone(vm.getGeneral().getTimeZone());
            model.setDefaultLocale(vm.getGeneral().getDefaultLocale());
            model.setDefaultCountry(vm.getGeneral().getDefaultCountry());
            model.setDefaultSalesPoint(vm.getGeneral().getDefaultSalesPoint());
            VMHelper.transfer((Collection)vm.getGeneral().getAdditionalLocales(), (Collection)model.getAdditionalLocales());
            model.setPersonalCabinetEnabled(vm.getGeneral().isPersonalCabinetEnabled());
            model.setPersonalDataLink(vm.getGeneral().getPersonalDataLink());
            model.getDisplayCurrencies().clear();
            model.getDisplayCurrencies().addAll(vm.getCurrencyConverter().stream().map(SMGeneralSettingsHandler::mapCurrencyDisplaySettingsFromVM).collect(Collectors.toList()));
            model.setDefaultPaymentType(vm.getGeneral().getDefaultPaymentType());
            model.setHideUnavailableServices(vm.getGeneral().isHideUnavailableServices());
            model.setGoogleMapsApiKey(vm.getGeneral().getGoogleMapsApiKey());
            model.setGeocoderApiToken(vm.getGeneral().getGeocoderApiToken());
            model.setGeocoderIwayGdsAccount(vm.getGeneral().getGeocoderIwayGdsAccount());
            model.setGeocoderApiTokenType(vm.getGeneral().getGeocoderApiTokenType());
            model.getCalendarSettings().setSaturdayForbidden(vm.getBookingRestrictions().getBannedDays().contains(Messages.Saturday));
            model.getCalendarSettings().setSundayForbidden(vm.getBookingRestrictions().getBannedDays().contains(Messages.Sunday));
            model.getCalendarSettings().setDaysShift(vm.getBookingRestrictions().getDaysShift() != null ? vm.getBookingRestrictions().getDaysShift() : 0);
            this.stringToDates(vm.getBookingRestrictions().getBannedDates(), model.getCalendarSettings().getExcludedDates());
            this.stringToEmails(vm.getBookingRestrictions().getBannedEmail(), model.getBannedEmail());
            model.getCalendarSettings().setStopTime(vm.getBookingRestrictions().getStopTime());
            MultiLingualText defaultDialogErrorMessage = vm.getErrorMessage().getDefaultDialogErrorMessage();
            if (defaultDialogErrorMessage != null) {
                L10nStringHelper.setValue((L10nString)model.getDefaultDialogErrorMessage(), (String)defaultDialogErrorMessage.getAz(), (Locale)LocaleHelper.getLocale((String)"az"));
                L10nStringHelper.setValue((L10nString)model.getDefaultDialogErrorMessage(), (String)defaultDialogErrorMessage.getBg(), (Locale)LocaleHelper.getLocale((String)"bg"));
                L10nStringHelper.setValue((L10nString)model.getDefaultDialogErrorMessage(), (String)defaultDialogErrorMessage.getEn(), (Locale)LocaleHelper.getLocale((String)"en"));
                L10nStringHelper.setValue((L10nString)model.getDefaultDialogErrorMessage(), (String)defaultDialogErrorMessage.getRu(), (Locale)LocaleHelper.getLocale((String)"ru"));
                L10nStringHelper.setValue((L10nString)model.getDefaultDialogErrorMessage(), (String)defaultDialogErrorMessage.getHy(), (Locale)LocaleHelper.getLocale((String)"hy"));
                L10nStringHelper.setValue((L10nString)model.getDefaultDialogErrorMessage(), (String)defaultDialogErrorMessage.getKa(), (Locale)LocaleHelper.getLocale((String)"ka"));
                L10nStringHelper.setValue((L10nString)model.getDefaultDialogErrorMessage(), (String)defaultDialogErrorMessage.getKz(), (Locale)LocaleHelper.getLocale((String)"kz"));
                L10nStringHelper.setValue((L10nString)model.getDefaultDialogErrorMessage(), (String)defaultDialogErrorMessage.getUk(), (Locale)LocaleHelper.getLocale((String)"uk"));
            }
        });
    }

    private static SMCurrencyDisplaySettingsVM mapCurrencyDisplaySettingsToVM(SMCurrencyDisplaySettings model) {
        SMCurrencyDisplaySettingsVM vm = new SMCurrencyDisplaySettingsVM();
        vm.setCurrency(model.getCurrency());
        vm.setRateType(model.getRateType());
        vm.setRiskRatio(model.getRiskRatio());
        vm.setRoundingValue(model.getRoundingValue());
        vm.setRoundingMode(model.getRoundingMode());
        return vm;
    }

    private static SMCurrencyDisplaySettings mapCurrencyDisplaySettingsFromVM(SMCurrencyDisplaySettingsVM vm) {
        SMCurrencyDisplaySettings model = new SMCurrencyDisplaySettings();
        model.setCurrency(vm.getCurrency());
        model.setRateType(vm.getRateType());
        model.setRiskRatio(vm.getRiskRatio());
        model.setRoundingValue(vm.getRoundingValue());
        model.setRoundingMode(vm.getRoundingMode());
        return model;
    }

    protected ViewController<SMGeneralSettingsContainer, SMGeneralSettingsContainerVM> createSpaceController(boolean readonly) {
        return new SMGeneralSettingsContainerController(readonly);
    }

    protected SMGeneralSettingsContainerVM createVM() {
        return new SMGeneralSettingsContainerVM();
    }

    public String format(EntityContainer<SMGeneralSettings> ctr) {
        return L10n.replace((String)Messages.SMGeneralSettings_name, (Object[])new Object[]{((SMGeneralSettings)ctr.getEntity()).getSite().getCaption() != null ? ((SMGeneralSettings)ctr.getEntity()).getSite().getCaption() : Messages.No_Name_Site});
    }

    private String datesToString(Set<Date> dates) {
        if (dates.isEmpty()) {
            return "";
        }
        DateFormat formatter = ((LocaleManager)Environment.getPublished(LocaleManager.class)).getCurrentLocaleData().getDateFormat();
        StringBuilder buf = new StringBuilder();
        for (Date date : dates) {
            buf.append(formatter.format(date));
            buf.append(", ");
        }
        buf.delete(buf.length() - 2, buf.length());
        return buf.toString();
    }

    private void stringToDates(String string, Set<Date> dates) {
        if (string.isEmpty()) {
            return;
        }
        dates.clear();
        try {
            DateFormat format = (DateFormat)((LocaleManager)Environment.getPublished(LocaleManager.class)).getCurrentLocaleData().getDateFormat().clone();
            format.setLenient(false);
            for (String buf : string.split(",")) {
                dates.add(format.parse(buf));
            }
        }
        catch (ParseException pe) {
            Notifications.get().showFlashNotification(Messages.Parsing_error, pe.getMessage());
        }
    }

    private String emailsToString(Set<String> dates) {
        return String.join((CharSequence)",", dates);
    }

    private void stringToEmails(String string, Set<String> dates) {
        if (string.isEmpty()) {
            return;
        }
        dates.clear();
        Collections.addAll(dates, string.split(","));
    }
}

