/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.entity.tasks;

import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.ibecorp.entity.tasks.BaseShipmentDocumentsTask;
import com.gridnine.xtrip.client.fx.ibecorp.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.ibecorp.rpc.IbecorpModelService;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.jr.JasperUtil;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.LazyValueHolder;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.awt.Desktop;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.printing.PDFPrintable;
import org.apache.pdfbox.printing.Scaling;

public abstract class BasePrintShipmentDocumentsTask
extends BaseShipmentDocumentsTask {
    protected String getTitle() {
        return Messages.PrintDocuments;
    }

    protected void execute() throws Exception {
        boolean xReportsEnabled = Prefetched.getData().isXreportsIntegrationEnabled();
        if (!xReportsEnabled) {
            this.addMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.XreportsIntegrationDisabled, (Object[])new Object[0])});
        }
        LazyValueHolder desktopForPrint = new LazyValueHolder(this::getAndCheckDesktopForPrint);
        LazyValueHolder desktopForOpen = new LazyValueHolder(this::getAndCheckDesktopForOpen);
        boolean found = false;
        for (EntityReference<Shipment> shipment : this.getSortedShipments()) {
            IbecorpModelService.ShipmentDocumentsData printData = this.getPrintData(shipment, xReportsEnabled);
            this.showMessages(printData.getMessages());
            List<PrintDocument> printDocuments = this.getPrintDocuments(printData);
            ReportRegistry reportRegistry = this.getReportRegistries(printData);
            if (!printDocuments.isEmpty() || reportRegistry != null) {
                found = true;
            }
            this.printDocuments(printDocuments, (LazyValueHolder<Desktop>)desktopForPrint);
            this.openRegistry(reportRegistry, (LazyValueHolder<Desktop>)desktopForOpen);
        }
        if (!found) {
            this.showNotification(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.DocumentsForPrintNotFound, (Object[])new Object[0]));
        }
    }

    abstract List<EntityReference<Shipment>> getShipments();

    abstract FinanceDocumentsChangeSettings getFinanceDocumentsChangeSettings();

    private List<EntityReference<Shipment>> getSortedShipments() throws Exception {
        List<EntityReference<Shipment>> shipments = this.getShipments();
        if (shipments.size() < 2) {
            return shipments;
        }
        LinkedHashMap<EntityReference, List> shipmentsByCustomers = new LinkedHashMap<EntityReference, List>();
        for (EntityReference<Shipment> shipmentReference : shipments) {
            EntityContainer shipmentContainer = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), shipmentReference);
            if (EntityStorageHelper.isEmpty((EntityContainer)shipmentContainer)) continue;
            shipmentsByCustomers.computeIfAbsent(((Shipment)shipmentContainer.getEntity()).getCustomer(), c -> new ArrayList()).add(shipmentReference);
        }
        return shipmentsByCustomers.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private IbecorpModelService.ShipmentDocumentsData getPrintData(EntityReference<Shipment> shipment, boolean xReportsEnabled) throws Exception {
        FinanceDocumentsChangeSettings changeSettings = this.getFinanceDocumentsChangeSettings();
        return ((IbecorpModelService)RpcServiceManager.get().getService(IbecorpModelService.class)).getShipmentDocumentsData(ServiceInvocationContext.get(), shipment, changeSettings != null ? new IbecorpModelService.FinanceDocumentsChangeSettings(changeSettings.getAgent(), changeSettings.isUseDelegate(), changeSettings.isUseFacsimile()) : null, xReportsEnabled, true);
    }

    private List<PrintDocument> getPrintDocuments(IbecorpModelService.ShipmentDocumentsData printData) {
        ArrayList<PrintDocument> result = new ArrayList<PrintDocument>();
        printData.getFinanceDocuments().stream().map(PrintDocument::fromFinanceDocument).forEach(result::add);
        printData.getDocuments().stream().map(PrintDocument::fromDocument).forEach(result::add);
        return result;
    }

    private ReportRegistry getReportRegistries(IbecorpModelService.ShipmentDocumentsData printData) {
        return Optional.ofNullable(printData.getReportRegistry()).filter(it -> !it.isRegistryNotConfigured()).map(registry -> new ReportRegistry(registry.getFileName(), registry.getContent())).orElse(null);
    }

    private void printDocuments(List<PrintDocument> printDocuments, LazyValueHolder<Desktop> desktopHolder) throws Exception {
        this.convertJasperDocuments(printDocuments);
        for (PrintDocument printDocument : printDocuments) {
            if (printDocument.contentType == ContentType.PDF) {
                this.printPdfDocument(printDocument);
                continue;
            }
            this.printNonPdfDocument(printDocument, desktopHolder);
        }
    }

    private void convertJasperDocuments(List<PrintDocument> printDocuments) throws Exception {
        for (PrintDocument printDocument : printDocuments) {
            if (printDocument.contentType != ContentType.JASPERPRINT) continue;
            PrintDocument.access$102(printDocument, JasperUtil.convertToPdf((byte[])printDocument.content));
            printDocument.contentType = ContentType.PDF;
        }
    }

    private void printPdfDocument(PrintDocument printDocument) {
        try {
            for (int i = 0; i < printDocument.numberOfCopies; ++i) {
                PDDocument pdDocument = PDDocument.load((byte[])printDocument.content);
                this.rotatePagesIfNecessary(pdDocument);
                PDFPrintable printable = new PDFPrintable(pdDocument, Scaling.SCALE_TO_FIT);
                PrinterJob job = PrinterJob.getPrinterJob();
                job.setJobName(TextUtil.nonBlank((String)printDocument.reference.getCaption()) ? printDocument.reference.getCaption() : printDocument.reference.getUid());
                PageFormat pageFormat = new PageFormat();
                Paper paper = new Paper();
                paper.setImageableArea(10.0, 10.0, 595.0, 841.0);
                pageFormat.setPaper(paper);
                job.setPrintable((Printable)printable, pageFormat);
                job.print();
            }
        }
        catch (Exception e) {
            this.showNotification(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.PrintDocumentError, (Throwable)e, (Object[])new Object[]{printDocument.reference}));
        }
    }

    private void rotatePagesIfNecessary(PDDocument pdDocument) {
        for (PDPage page : pdDocument.getPages()) {
            boolean alreadyRotated;
            PDRectangle mediaBox = page.getMediaBox();
            boolean landscapeMode = mediaBox.getWidth() > mediaBox.getHeight();
            int rotation = page.getRotation();
            boolean bl = alreadyRotated = rotation == 90 || rotation == 270;
            if (landscapeMode && !alreadyRotated) {
                page.setRotation(90);
                continue;
            }
            if (landscapeMode || !alreadyRotated) continue;
            page.setRotation(0);
        }
    }

    private void printNonPdfDocument(PrintDocument printDocument, LazyValueHolder<Desktop> desktopHolder) throws Exception {
        Desktop desktop = (Desktop)desktopHolder.get();
        if (desktop == null) {
            return;
        }
        List<MiscUtil.Pair<File, PrintDocument>> tempFiles = this.savePrintDocumentToTempFiles(printDocument);
        for (MiscUtil.Pair<File, PrintDocument> tempFile : tempFiles) {
            try {
                desktop.print((File)tempFile.getFirst());
            }
            catch (Exception e) {
                this.showNotification(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.PrintDocumentError, (Throwable)e, (Object[])new Object[]{((PrintDocument)tempFile.getSecond()).reference}));
            }
        }
    }

    private void openRegistry(ReportRegistry reportRegistry, LazyValueHolder<Desktop> desktopHolder) throws Exception {
        if (reportRegistry == null) {
            return;
        }
        Desktop desktop = (Desktop)desktopHolder.get();
        if (desktop == null) {
            return;
        }
        File tempFile = this.saveReportRegistriesToTempFiles(reportRegistry);
        try {
            desktop.open(tempFile);
        }
        catch (Exception e) {
            this.showNotification(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.OpenRegistryError, (Throwable)e, (Object[])new Object[]{reportRegistry.fileName}));
        }
    }

    private Desktop getAndCheckDesktopForPrint() {
        if (!Desktop.isDesktopSupported()) {
            this.showNotification(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.BatchPrintingIsNotAvailable, (Object[])new Object[0]));
            return null;
        }
        Desktop desktop = Desktop.getDesktop();
        if (!desktop.isSupported(Desktop.Action.PRINT)) {
            this.showNotification(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.BatchPrintingIsNotAvailable, (Object[])new Object[0]));
            return null;
        }
        return desktop;
    }

    private Desktop getAndCheckDesktopForOpen() {
        if (!Desktop.isDesktopSupported()) {
            this.showNotification(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.OpenDocumentsIsNotAvailable, (Object[])new Object[0]));
            return null;
        }
        Desktop desktop = Desktop.getDesktop();
        if (!desktop.isSupported(Desktop.Action.OPEN)) {
            this.showNotification(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.OpenDocumentsIsNotAvailable, (Object[])new Object[0]));
            return null;
        }
        return desktop;
    }

    private List<MiscUtil.Pair<File, PrintDocument>> savePrintDocumentToTempFiles(PrintDocument printDocument) throws Exception {
        ArrayList<MiscUtil.Pair<File, PrintDocument>> tempFiles = new ArrayList<MiscUtil.Pair<File, PrintDocument>>();
        String fileExtension = this.getFileExtension(printDocument.contentType, printDocument.reference);
        if (fileExtension == null) {
            return tempFiles;
        }
        for (int i = 0; i < printDocument.numberOfCopies; ++i) {
            File tempFile = File.createTempFile("xtrip-doc-", fileExtension);
            FxUtil.saveToFile((File)tempFile, (byte[])printDocument.content);
            tempFile.deleteOnExit();
            tempFiles.add((MiscUtil.Pair<File, PrintDocument>)new MiscUtil.Pair((Object)tempFile, (Object)printDocument));
        }
        return tempFiles;
    }

    private File saveReportRegistriesToTempFiles(ReportRegistry reportRegistry) throws Exception {
        String fileName = FilenameUtils.getBaseName((String)reportRegistry.fileName);
        String extension = FilenameUtils.getExtension((String)reportRegistry.fileName);
        File tempFile = File.createTempFile(fileName, "." + extension);
        FxUtil.saveToFile((File)tempFile, (byte[])reportRegistry.content);
        tempFile.deleteOnExit();
        return tempFile;
    }

    private static class ReportRegistry {
        private String fileName;
        private byte[] content;

        ReportRegistry(String fileName, byte[] content) {
            this.fileName = fileName;
            this.content = content;
        }
    }

    private static class PrintDocument {
        private EntityReference<?> reference;
        private ContentType contentType;
        private byte[] content;
        private int numberOfCopies;

        private PrintDocument(EntityReference<?> reference, ContentType contentType, byte[] content, int numberOfCopies) {
            this.reference = Objects.requireNonNull(reference);
            this.contentType = Objects.requireNonNull(contentType, () -> "type is absent for document " + reference);
            this.content = Objects.requireNonNull(content, () -> "content is absent for document " + reference);
            this.numberOfCopies = numberOfCopies;
        }

        static PrintDocument fromDocument(IbecorpModelService.ShipmentDocumentsData.DocumentData document) {
            return new PrintDocument(document.getContainer().toReference(), ((Document)document.getContainer().getEntity()).getContentType(), ((Document)document.getContainer().getEntity()).getContent(), document.getNumberOfCopies());
        }

        static PrintDocument fromFinanceDocument(IbecorpModelService.ShipmentDocumentsData.FinanceDocumentData financeDocumentData) {
            return new PrintDocument(financeDocumentData.getContainer().toReference(), ((FinanceDocument)financeDocumentData.getContainer().getEntity()).getContent().getContentType(), ((FinanceDocument)financeDocumentData.getContainer().getEntity()).getContent().getData(), financeDocumentData.getNumberOfCopies());
        }

        static /* synthetic */ byte[] access$102(PrintDocument x0, byte[] x1) {
            x0.content = x1;
            return x1;
        }
    }

    public static class FinanceDocumentsChangeSettings {
        private final EntityReference<Person> agent;
        private final boolean useDelegate;
        private final boolean useFacsimile;

        public EntityReference<Person> getAgent() {
            return this.agent;
        }

        public boolean isUseDelegate() {
            return this.useDelegate;
        }

        public boolean isUseFacsimile() {
            return this.useFacsimile;
        }

        public FinanceDocumentsChangeSettings(EntityReference<Person> agent, boolean useDelegate, boolean useFacsimile) {
            this.agent = Objects.requireNonNull(agent);
            this.useDelegate = useDelegate;
            this.useFacsimile = useFacsimile;
        }
    }
}

