/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.entity.tasks;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.lib.widgets.FileChooserWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.ibecorp.entity.tasks.BaseShipmentDocumentsTask;
import com.gridnine.xtrip.client.fx.ibecorp.l10n.Messages;
import com.gridnine.xtrip.common.fx.ibecorp.rpc.IbecorpModelService;
import com.gridnine.xtrip.common.jr.JasperUtil;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanExpression;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import org.apache.commons.io.FileUtils;

public abstract class BaseSaveShipmentDocumentsTask
extends BaseShipmentDocumentsTask {
    protected String getTitle() {
        return Messages.LoadDocuments;
    }

    protected void execute() throws Exception {
        ArrayList<IbecorpModelService.ShipmentDocumentsData> shipmentDocumentsDatas = new ArrayList<IbecorpModelService.ShipmentDocumentsData>();
        for (EntityReference<Shipment> shipment : this.getShipments()) {
            IbecorpModelService.ShipmentDocumentsData shipmentDocumentsData = ((IbecorpModelService)RpcServiceManager.get().getService(IbecorpModelService.class)).getShipmentDocumentsData(ServiceInvocationContext.get(), shipment, null, false, false);
            shipmentDocumentsDatas.add(shipmentDocumentsData);
        }
        for (IbecorpModelService.ShipmentDocumentsData shipmentDocumentsData : shipmentDocumentsDatas) {
            this.showMessages(shipmentDocumentsData.getMessages());
        }
        List<DocumentSaveData> documents = this.getDocuments(shipmentDocumentsDatas);
        if (documents.isEmpty()) {
            this.showNotification(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.DocumentsForSaveNotFound, (Object[])new Object[0]));
            return;
        }
        this.saveDocuments(documents);
    }

    abstract List<EntityReference<Shipment>> getShipments();

    private List<DocumentSaveData> getDocuments(List<IbecorpModelService.ShipmentDocumentsData> shipmentDocumentsDatas) {
        ArrayList<DocumentSaveData> result = new ArrayList<DocumentSaveData>();
        for (IbecorpModelService.ShipmentDocumentsData shipmentDocumentsData : shipmentDocumentsDatas) {
            shipmentDocumentsData.getFinanceDocuments().stream().map(DocumentSaveData::fromFinanceDocument).forEach(result::add);
            shipmentDocumentsData.getDocuments().stream().map(DocumentSaveData::fromDocument).forEach(result::add);
        }
        return result;
    }

    private void saveDocuments(List<DocumentSaveData> documents) throws Exception {
        this.convertJasperDocuments(documents);
        FxUtil.waitForFxThread(() -> {
            FileChooserWidget fileChooserWidget = new FileChooserWidget(false);
            fileChooserWidget.setMode(FileChooserWidget.ChoosingMode.CHOOSE_DIRECTORY);
            new Dialog().setBody((Node)fileChooserWidget).setTitle(Messages.SelectDirectoryForSaveDocuments).addButton(DialogButtonStyle.ACCEPT_REGULAR, com.gridnine.xtrip.client.fx.core.l10n.Messages.General_Save, () -> {
                File folder = (File)CollectionUtil.head((Iterable)fileChooserWidget.getFiles());
                this.saveDocumentsToFolder(documents, folder);
            }, (BooleanExpression)Bindings.isNotEmpty((ObservableList)fileChooserWidget.getFiles())).showGlobal();
        });
    }

    private void saveDocumentsToFolder(List<DocumentSaveData> documents, File directory) {
        boolean saved = false;
        for (DocumentSaveData document : documents) {
            try {
                String fileName;
                String string = fileName = TextUtil.nonBlank((String)document.name) ? document.name : "document";
                String extension = this.getFileExtension(document.contentType, document.reference);
                if (extension == null) continue;
                if (!fileName.endsWith(extension)) {
                    fileName = fileName + extension;
                }
                File file = new File(directory, fileName);
                while (file.exists()) {
                    String name = file.getName();
                    int extensionIndex = name.lastIndexOf(extension);
                    name = (extensionIndex > 0 ? name.substring(0, extensionIndex) : "") + "(2)" + extension;
                    file = new File(directory, name);
                }
                FileUtils.writeByteArrayToFile((File)file, (byte[])document.content);
                saved = true;
            }
            catch (Exception e) {
                this.showNotification(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.SaveDocumentError, (Throwable)e, (Object[])new Object[]{document.reference}));
            }
        }
        if (saved) {
            Notifications.get().showMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.DocumentsSavedToDirectory, (Object[])new Object[]{directory.getAbsolutePath()})});
        }
    }

    private void convertJasperDocuments(List<DocumentSaveData> printDocuments) throws Exception {
        for (DocumentSaveData printDocument : printDocuments) {
            if (printDocument.contentType != ContentType.JASPERPRINT) continue;
            DocumentSaveData.access$302(printDocument, JasperUtil.convertToPdf((byte[])printDocument.content));
            printDocument.contentType = ContentType.PDF;
        }
    }

    private static class DocumentSaveData {
        private EntityReference<?> reference;
        private String name;
        private ContentType contentType;
        private byte[] content;

        private DocumentSaveData(EntityReference<?> reference, String name, ContentType contentType, byte[] content) {
            this.reference = reference;
            this.name = name;
            this.contentType = Objects.requireNonNull(contentType, () -> "type is absent for document " + reference);
            this.content = Objects.requireNonNull(content, () -> "content is absent for document " + reference);
        }

        static DocumentSaveData fromDocument(IbecorpModelService.ShipmentDocumentsData.DocumentData document) {
            return new DocumentSaveData(document.getContainer().toReference(), ((Document)document.getContainer().getEntity()).getName(), ((Document)document.getContainer().getEntity()).getContentType(), ((Document)document.getContainer().getEntity()).getContent());
        }

        static DocumentSaveData fromFinanceDocument(IbecorpModelService.ShipmentDocumentsData.FinanceDocumentData financeDocumentData) {
            return new DocumentSaveData(financeDocumentData.getContainer().toReference(), DocumentSaveData.generateName(financeDocumentData), ((FinanceDocument)financeDocumentData.getContainer().getEntity()).getContent().getContentType(), ((FinanceDocument)financeDocumentData.getContainer().getEntity()).getContent().getData());
        }

        private static String generateName(IbecorpModelService.ShipmentDocumentsData.FinanceDocumentData financeDocumentData) {
            FinanceDocument financeDocument = (FinanceDocument)financeDocumentData.getContainer().getEntity();
            return String.format("%s \u2116 %s \u043e\u0442 %s", financeDocument.getType() != null ? financeDocument.getType().toString() : "?", TextUtil.nonBlank((String)financeDocument.getNumber()) ? financeDocument.getNumber() : "?", financeDocument.getDate() != null ? new SimpleDateFormat("dd.MM.yyyy").format(financeDocument.getDate()) : "?");
        }

        static /* synthetic */ byte[] access$302(DocumentSaveData x0, byte[] x1) {
            x0.content = x1;
            return x1;
        }
    }
}

