/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.lrt.handlers;

import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.ibecorp.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.lrt.LrtHandler;
import com.gridnine.xtrip.common.ibecorp.model.ComplementBookingsTaskConfiguration;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.DateUtils;
import java.io.Serializable;
import java.time.LocalDate;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.BooleanExpression;
import javafx.scene.Node;

public class ComplementBookingsTaskHandler
implements LrtHandler<Configurator> {
    public String getId() {
        return "ComplementBookingsTask";
    }

    public String getName() {
        return L10nResourcesManager.createL10nMessage((String)Messages.ComplementBookingsTaskConfiguration_description, (Object[])new Object[0]).toString();
    }

    public String getTaskClassName() {
        return "com.gridnine.xtrip.server.ibecorp.tasks.ComplementBookingsTask";
    }

    public Configurator createConfigurator() {
        return new Configurator();
    }

    public BooleanExpression createAvailability(Configurator configurator) {
        return configurator.createAvailability();
    }

    public Serializable getConfiguration(Configurator configurator) {
        return configurator.createConfiguration();
    }

    static final class Configurator
    extends GridContainer {
        private final DateValueWidget dateFromWidget = new DateValueWidget(false);
        private final DateValueWidget dateToWidget = new DateValueWidget(false);
        private final ComboBoxWidget<GdsName> gdsWidget = new ComboBoxWidget(false);
        private final EntityBoxWidget<Organization> agencyWidget = new EntityBoxWidget(Organization.class, false);
        private final EntityBoxWidget<Organization> subAgencyWidget = new EntityBoxWidget(Organization.class, false);
        private final EntityBoxWidget<Organization> clientWidget = new EntityBoxWidget(Organization.class, false);
        private final ComboBoxWidget<TravelSubject> travelSubjectWidget = new ComboBoxWidget(true);

        Configurator() {
            super(2);
            this.dateFromWidget.setValue(LocalDate.now().minusDays(1L));
            this.getCells().add((Object)new GridCell("\u0414\u0430\u0442\u0430 \u043e\u0442", (Node)this.dateFromWidget));
            this.dateToWidget.setValue(LocalDate.now().minusDays(1L));
            this.getCells().add((Object)new GridCell("\u0414\u0430\u0442\u0430 \u0434\u043e", (Node)this.dateToWidget));
            this.travelSubjectWidget.setValue((Object)TravelSubject.AIR);
            this.getCells().add((Object)new GridCell("\u0422\u0438\u043f \u043f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0438\u044f", this.travelSubjectWidget));
            this.gdsWidget.setItemsSupplier(Suppliers.createEnumSupplier(GdsName.class));
            this.getCells().add((Object)new GridCell("\u0421\u0438\u0441\u0442\u0435\u043c\u0430 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f", this.gdsWidget));
            this.agencyWidget.setListParametersSupplier(ControllerInterceptorsHelper::getAgencies);
            this.getCells().add((Object)new GridCell("\u0410\u0433\u0435\u043d\u0441\u0442\u0432\u043e", this.agencyWidget));
            this.subAgencyWidget.setListParametersSupplier(ControllerInterceptorsHelper::getAgencies);
            this.getCells().add((Object)new GridCell("\u0421\u0443\u0431\u0430\u0433\u0435\u043d\u0441\u0442\u0432\u043e", this.subAgencyWidget));
            this.clientWidget.setListParametersSupplier(ControllerInterceptorsHelper::getClients);
            this.getCells().add((Object)new GridCell("\u041a\u043b\u0438\u0435\u043d\u0442", this.clientWidget));
        }

        BooleanExpression createAvailability() {
            return new BooleanBinding(){
                {
                    this.bind(new Observable[]{dateFromWidget.valueProperty(), dateToWidget.valueProperty()});
                }

                protected boolean computeValue() {
                    return dateFromWidget.getValue() != null && (dateToWidget.getValue() == null || !dateFromWidget.getValue().isAfter(dateToWidget.getValue()));
                }
            };
        }

        ComplementBookingsTaskConfiguration createConfiguration() {
            ComplementBookingsTaskConfiguration configuration = new ComplementBookingsTaskConfiguration();
            configuration.setDateFrom(DateUtils.toJavaDate((LocalDate)this.dateFromWidget.getValue()));
            configuration.setDateTo(DateUtils.toJavaDate((LocalDate)this.dateToWidget.getValue()));
            configuration.setAgency(this.agencyWidget.getValue());
            configuration.setSubagency(this.subAgencyWidget.getValue());
            configuration.setClient(this.clientWidget.getValue());
            configuration.setGds((GdsName)this.gdsWidget.getValue());
            return configuration;
        }
    }
}

