/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.lrt.handlers;

import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.ibecorp.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.helpers.ListParametersHelper;
import com.gridnine.xtrip.client.fx.standard.lrt.LrtHandler;
import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.ibecorp.model.InMobGdsAccount;
import com.gridnine.xtrip.common.ibecorp.model.SyncImRailRefundsTaskConfiguration;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.gds.GdsAccountIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.util.DateUtils;
import java.io.Serializable;
import java.time.LocalDate;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.scene.Node;

public class SyncImRailRefundsTaskHandler
implements LrtHandler<Configurator> {
    public String getId() {
        return "SyncImRailRefundsTask";
    }

    public String getName() {
        return L10nResourcesManager.createL10nMessage((String)Messages.SyncImRailRefundsTask_description, (Object[])new Object[0]).toString();
    }

    public String getTaskClassName() {
        return "com.gridnine.xtrip.server.ibecorp.tasks.SyncImRailRefundsTask";
    }

    public Configurator createConfigurator() {
        return new Configurator();
    }

    public BooleanExpression createAvailability(Configurator configurator) {
        return configurator.createAvailability();
    }

    public Serializable getConfiguration(Configurator configurator) {
        return configurator.createConfiguration();
    }

    static final class Configurator
    extends GridContainer {
        private final DateValueWidget dateWidget = new DateValueWidget(false);
        private final EntityBoxWidget<BaseGdsAccount> gdsAccountWidget = new EntityBoxWidget(InMobGdsAccount.class, false);
        private final BooleanValueWidget onlyExternalWidget = new BooleanValueWidget(false, false);
        private final BooleanValueWidget saveLogsWidget = new BooleanValueWidget(false, false);

        Configurator() {
            super(2);
            this.dateWidget.setValue(LocalDate.now().minusDays(1L));
            this.getCells().add((Object)new GridCell("\u0414\u0430\u0442\u0430 \u0441\u0432\u0435\u0440\u043a\u0438", (Node)this.dateWidget));
            this.gdsAccountWidget.setListParametersSupplier(() -> {
                IndexListParameters result = new IndexListParameters();
                result.setIndexType(GdsAccountIndex.class);
                result.getSearchCriterions().add(SearchCriterion.eq((String)GdsAccountIndex.Property.gds.name(), (Object)GdsName.INMOB));
                ListParametersHelper.setColumns((IndexListParameters)result, (String[])new String[]{GdsAccountIndex.Property.name.name(), GdsAccountIndex.Property.agency.name()});
                return result;
            });
            this.getCells().add((Object)new GridCell("\u0410\u043a\u043a\u0430\u0443\u043d\u0442 \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f", this.gdsAccountWidget));
            this.getCells().add((Object)new GridCell("\u0422\u043e\u043b\u044c\u043a\u043e \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u043d\u044b\u0435 \u0432 \u043a\u0430\u0441\u0441\u0430\u0445 \u0420\u0416\u0414", (Node)this.onlyExternalWidget));
            this.getCells().add((Object)new GridCell("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u043b\u043e\u0433", (Node)this.saveLogsWidget));
        }

        BooleanExpression createAvailability() {
            return Bindings.and((ObservableBooleanValue)Bindings.isNotNull((ObservableObjectValue)this.dateWidget.valueProperty()), (ObservableBooleanValue)Bindings.isNotNull((ObservableObjectValue)this.gdsAccountWidget.valueProperty()));
        }

        SyncImRailRefundsTaskConfiguration createConfiguration() {
            SyncImRailRefundsTaskConfiguration configuration = new SyncImRailRefundsTaskConfiguration();
            configuration.setDate(DateUtils.toJavaDate((LocalDate)this.dateWidget.getValue()));
            EntityReference gdsAccount = this.gdsAccountWidget.getValue();
            configuration.setGdsAccount(gdsAccount);
            configuration.setOnlyExternal(this.onlyExternalWidget.getValue());
            configuration.setSaveLogs(this.saveLogsWidget.getValue());
            return configuration;
        }
    }
}

