/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.lrt.handlers;

import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.ibecorp.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.lrt.LrtHandler;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.ibecorp.model.UdidValueDeletionTaskConfiguration;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.io.Serializable;
import java.util.Collections;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.util.StringConverter;

public class UdidValueDeletionTaskHandler
implements LrtHandler<Configurator> {
    public String getTaskClassName() {
        return "com.gridnine.xtrip.server.ibecorp.tasks.UdidValueDeletionTask";
    }

    public Configurator createConfigurator() {
        return new Configurator();
    }

    public Serializable getConfiguration(Configurator configurator) {
        return configurator.createConfiguration();
    }

    public String getId() {
        return "UdidValueDeletionTask";
    }

    public String getName() {
        return L10nResourcesManager.createL10nMessage((String)Messages.UdidValueDeletionTask_description, (Object[])new Object[0]).toString();
    }

    public BooleanExpression createAvailability(Configurator configurator) {
        return configurator.createAvailability();
    }

    static final class Configurator
    extends GridContainer {
        private final EntityBoxWidget<Organization> organizationWidget = new EntityBoxWidget(Organization.class, false);
        private final ComboBoxWidget<CostCodeProperties> costCodeWidget;

        Configurator() {
            super(2);
            this.organizationWidget.setFieldName(com.gridnine.xtrip.client.fx.standard.l10n.Messages.Client);
            this.organizationWidget.setListParametersSupplier(ControllerInterceptorsHelper::getClients);
            this.costCodeWidget = new ComboBoxWidget(false);
            this.costCodeWidget.setConverter((StringConverter)new StringConverter<CostCodeProperties>(){

                public String toString(CostCodeProperties prop) {
                    return prop != null ? prop.getName() : null;
                }

                public CostCodeProperties fromString(String string) {
                    return null;
                }
            });
            this.costCodeWidget.setLive(true);
            this.costCodeWidget.setAsync(true);
            this.costCodeWidget.setItemsSupplier(() -> {
                Organization organization = this.loadOrganization();
                return organization != null ? organization.getCostCodeProperties() : Collections.emptyList();
            });
            this.organizationWidget.valueProperty().addListener((s, oldValue, newValue) -> {
                if (!MiscUtil.equals((Object)oldValue, (Object)newValue)) {
                    this.costCodeWidget.setValue(null);
                    this.costCodeWidget.redraw();
                }
            });
            this.getCells().add((Object)new GridCell("\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f", this.organizationWidget));
            this.getCells().add((Object)new GridCell("\u0422\u0438\u043f UDID", this.costCodeWidget));
        }

        BooleanExpression createAvailability() {
            return Bindings.and((ObservableBooleanValue)Bindings.isNotNull((ObservableObjectValue)this.organizationWidget.valueProperty()), (ObservableBooleanValue)Bindings.isNotNull((ObservableObjectValue)this.costCodeWidget.valueProperty()));
        }

        UdidValueDeletionTaskConfiguration createConfiguration() {
            UdidValueDeletionTaskConfiguration configuration = new UdidValueDeletionTaskConfiguration();
            configuration.setOrganization(this.organizationWidget.getValue());
            configuration.setCategory(((CostCodeProperties)this.costCodeWidget.getValue()).getCategory());
            return configuration;
        }

        private Organization loadOrganization() {
            EntityReference orgReference = this.organizationWidget.getValue();
            if (orgReference == null) {
                return null;
            }
            try {
                EntityContainer orgContainer = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), orgReference);
                if (orgContainer != null) {
                    return (Organization)orgContainer.getEntity();
                }
            }
            catch (Exception e) {
                ErrorHandler.handle((Throwable)e);
            }
            return null;
        }
    }
}

