/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.processing;

import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.registry.basic.AppStartHook;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.ibecorp.entity.actions.RegenerateShipmentRegistryAction;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.finance.ShipmentIndex;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessShipmentReportRegistriesHook
implements AppStartHook {
    public double getWeight() {
        return 1.0;
    }

    public void execute() {
        if (Prefetched.getData().isSbisIntegrationEnabled()) {
            Notifications.get().getScheduler().scheduleWithFixedDelay(new ProcessShipmentReportRegistriesTask(), 10L, 10L, TimeUnit.SECONDS);
        }
    }

    public String getId() {
        return "process-shipment-report-registries";
    }

    static class ProcessShipmentReportRegistriesTask
    implements Runnable {
        private final Logger log = LoggerFactory.getLogger(this.getClass());

        ProcessShipmentReportRegistriesTask() {
        }

        @Override
        public void run() {
            if (!RegenerateShipmentRegistryAction.destDir.exists()) {
                return;
            }
            for (File file : RegenerateShipmentRegistryAction.destDir.listFiles()) {
                try {
                    EntityReference shipmentRef;
                    String fileName = file.getName();
                    if (file.isDirectory() || fileName.contains("~lock") || !fileName.endsWith(".xlsx") && !fileName.endsWith(".xlsm")) continue;
                    String shipmentNumber = fileName.substring(0, fileName.lastIndexOf("."));
                    SearchQuery query = new SearchQuery();
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ShipmentIndex.Property.number.name(), (Object)shipmentNumber));
                    EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
                    List shipmentIndices = entityService.search(ServiceInvocationContext.get(), ShipmentIndex.class, query);
                    EntityReference entityReference = shipmentRef = shipmentIndices.isEmpty() ? null : ((ShipmentIndex)shipmentIndices.get(0)).getSource();
                    if (shipmentRef == null) {
                        this.log.warn("no shipment found for file " + fileName);
                        this.moveTo(file, "error");
                        continue;
                    }
                    String documentFileName = fileName;
                    query = new SearchQuery();
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.owner.name(), (Object)shipmentRef));
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.name.name(), (Object)documentFileName));
                    List documentIndices = entityService.search(ServiceInvocationContext.get(), BasicDocumentIndex.class, query);
                    boolean hasSame = false;
                    byte[] content = FileUtils.readFileToByteArray((File)file);
                    String checkSum = MiscUtil.getCheckSum((byte[])content);
                    for (BasicDocumentIndex idx : documentIndices) {
                        if (checkSum.equals(idx.getCheckSum())) {
                            hasSame = true;
                            continue;
                        }
                        entityService.delete(ServiceInvocationContext.get(), idx.getSource());
                    }
                    if (!hasSame) {
                        Document doc = new Document();
                        doc.setName(documentFileName);
                        doc.setType(DocumentType.SHIPMENT_TICKETS_REGISTRY);
                        doc.setOwner(shipmentRef);
                        doc.setContent(content);
                        doc.setContentType(ContentType.EXCEL_2007);
                        doc.setTitle("\u0420\u0435\u0435\u0441\u0442\u0440 \u0434\u043b\u044f \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 " + shipmentNumber);
                        doc.setCreated(new Date());
                        doc.setCheckSum(checkSum);
                        EntityContainer docCtr = EntityContainer.create((BaseEntity)doc);
                        docCtr.getVersionInfo().setDataSource("ProcessShipmentReportRegistriesTask");
                        entityService.save(ServiceInvocationContext.get(), docCtr, null, true);
                        EventBus.get().publishAsync((Event)new EntityModificationEvent(null, new EntityModification(shipmentRef, EntityModification.ModificationType.CHANGE)));
                    }
                    this.moveTo(file, "processed");
                }
                catch (Exception e) {
                    this.log.error("unable to process file " + file.getName(), (Throwable)e);
                    this.moveTo(file, "error");
                }
            }
        }

        private void moveTo(File file, String directory) {
            File dir = new File(RegenerateShipmentRegistryAction.destDir, directory + "/");
            try {
                dir.mkdirs();
                File destFile = new File(dir, file.getName());
                if (destFile.exists()) {
                    destFile.delete();
                }
                FileUtils.moveFile((File)file, (File)new File(dir, file.getName()));
            }
            catch (IOException e) {
                this.log.error(String.format("unable to move file %s to %s", file, dir), (Throwable)e);
            }
        }
    }
}

