/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.rules;

import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.MoneyValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.multi.MultiEntityWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ValuesWidget;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.standard.helpers.ListParametersHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.client.fx.standard.renderer.StandardValueRenderers;
import com.gridnine.xtrip.client.fx.standard.rules.renderers.RuleValueRenderer;
import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.finance.CompanyRelation;
import com.gridnine.xtrip.common.model.gds.GdsAccountIndex;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.ibecorp.AuthorizationActionType;
import com.gridnine.xtrip.common.model.ibecorp.NotificationType;
import com.gridnine.xtrip.common.model.ibecorp.PriceDetailDisplayArea;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.search.SearchCriterion;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javafx.collections.ObservableList;
import javafx.scene.Node;

public enum IbecorpRuleValueRenders implements RuleValueRenderer
{
    AUTHORIZATION_ACTION_TYPE{

        public Node createNode(boolean readonly) {
            ValuesWidget widget = new ValuesWidget(readonly);
            widget.setItemsSupplier(() -> Arrays.asList(AuthorizationActionType.values()));
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return new ArrayList(((ValuesWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            List list = value == null ? new ArrayList() : (List)value;
            ((ValuesWidget)node).getValues().setAll(list);
        }

        public boolean isValueEmpty(Node node) {
            return node == null || ((ValuesWidget)node).getValues().isEmpty();
        }
    }
    ,
    PRICE_WITH_CURRENCY{

        public Node createNode(boolean readonly) {
            return new MoneyValueWidget(readonly);
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((MoneyValueWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((MoneyValueWidget)node).setValue(this.getValue(value));
        }

        private Money getValue(Object value) {
            if (value instanceof BigDecimal) {
                return MoneyHelper.buildMoney((BigDecimal)((BigDecimal)value), (String)Prefetched.getData().getEquivalentCurrency());
            }
            return (Money)value;
        }

        @Override
        public void buildRestrictionsInfo(Consumer<String> out, RuleRestriction ruleRestriction) {
            RuleProperty property = ruleRestriction.getProperty();
            StringBuilder builder = new StringBuilder();
            property.buildInfo(builder, ruleRestriction.getCondition(), (Object)this.getValue(ruleRestriction.getValue()));
            out.accept(builder.toString());
        }

        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    COMPANY_RELATION{

        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }

        public Node createNode(boolean readonly) {
            ComboBoxWidget node = new ComboBoxWidget(readonly);
            node.setItemsSupplier(Suppliers.createEnumSupplier(CompanyRelation.class));
            return node;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return null;
            }
            return ((ComboBoxWidget)node).getValue();
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            ((ComboBoxWidget)node).setValue((Object)((CompanyRelation)value));
        }
    }
    ,
    SM_SITE_TYPE{

        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }

        public Node createNode(boolean readonly) {
            Node node = StandardValueRenderers.ENUM.createNode(SMSiteType.class);
            StandardValueRenderers.ENUM.setEditable(node, !readonly);
            return node;
        }

        public Object getValue(Node node) {
            return StandardValueRenderers.ENUM.getValue(node);
        }

        public void setValue(Node node, Object value) {
            StandardValueRenderers.ENUM.setValue(node, value);
        }
    }
    ,
    SBIS_FINANCE_DOCUMENT_TYPE{

        public Node createNode(boolean readonly) {
            ValuesWidget widget = new ValuesWidget(readonly);
            widget.setItemsSupplier(() -> Arrays.asList(FinanceDocumentType.INVOICE, FinanceDocumentType.INVOICE_FACTURA, FinanceDocumentType.INVOICE_FACTURA_FEES, FinanceDocumentType.ACCEPTANCE_CERTIFICATE, FinanceDocumentType.UNIVERSAL_DOCUMENT));
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return Collections.emptyList();
            }
            return new ArrayList(((ValuesWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            List list = value != null ? (List)value : Collections.emptyList();
            ((ValuesWidget)node).getValues().setAll((Collection)list);
        }

        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    PRICE_DETAIL_DISPLAY_AREA{

        public Node createNode(boolean readonly) {
            ValuesWidget widget = new ValuesWidget(readonly);
            widget.setItemsSupplier(Suppliers.createEnumSupplier(PriceDetailDisplayArea.class));
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return Collections.emptyList();
            }
            return new ArrayList(((ValuesWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            List list = value != null ? (List)value : Collections.emptyList();
            ((ValuesWidget)node).getValues().setAll((Collection)list);
        }

        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    NOTIFICATION_TYPES{

        public Node createNode(boolean readonly) {
            ValuesWidget widget = new ValuesWidget(readonly);
            widget.setItemsSupplier(Suppliers.createEnumSupplier(NotificationType.class));
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return Collections.emptyList();
            }
            return new ArrayList(((ValuesWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            List list = value != null ? (List)value : Collections.emptyList();
            ((ValuesWidget)node).getValues().setAll((Collection)list);
        }

        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    NOTIFICATION_TYPES_AVIA{
        private final Set<NotificationType> AVAILABLE_TYPES = EnumSet.of(NotificationType.RESERVATION_CREATED, new NotificationType[]{NotificationType.RESERVATION_CANCELLED, NotificationType.SERVICES_ISSUED, NotificationType.RESERVATION_VOIDED, NotificationType.PAYMENT_REFUND, NotificationType.VISA_INFORMATION, NotificationType.TIME_LIMIT_EXPIRING, NotificationType.TIME_LIMIT_CHANGED, NotificationType.INTENTION_CANCELLED});

        public Node createNode(boolean readonly) {
            ValuesWidget widget = new ValuesWidget(readonly);
            widget.setItemsSupplier(Suppliers.createEnumSupplier(NotificationType.class, this.AVAILABLE_TYPES::contains));
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return Collections.emptyList();
            }
            return new ArrayList(((ValuesWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            List list = value != null ? (List)value : Collections.emptyList();
            ((ValuesWidget)node).getValues().setAll((Collection)list);
        }

        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    NOTIFICATION_TYPES_RAIL{
        private final Set<NotificationType> AVAILABLE_TYPES = EnumSet.of(NotificationType.RESERVATION_CREATED, NotificationType.RESERVATION_CANCELLED, NotificationType.SERVICES_ISSUED, NotificationType.PAYMENT_REFUND, NotificationType.INTENTION_CANCELLED);

        public Node createNode(boolean readonly) {
            ValuesWidget widget = new ValuesWidget(readonly);
            widget.setItemsSupplier(Suppliers.createEnumSupplier(NotificationType.class, this.AVAILABLE_TYPES::contains));
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return Collections.emptyList();
            }
            return new ArrayList(((ValuesWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            List list = value != null ? (List)value : Collections.emptyList();
            ((ValuesWidget)node).getValues().setAll((Collection)list);
        }

        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    NOTIFICATION_TYPES_HOTELS{
        private final Set<NotificationType> AVAILABLE_TYPES = EnumSet.of(NotificationType.SERVICES_ISSUED, new NotificationType[]{NotificationType.PAYMENT_REFUND, NotificationType.RESERVATION_REQUEST_CREATED, NotificationType.RESERVATION_REQUEST_REJECTED, NotificationType.RESERVATION_REQUEST_CONFIRMED, NotificationType.INTENTION_CANCELLED});

        public Node createNode(boolean readonly) {
            ValuesWidget widget = new ValuesWidget(readonly);
            widget.setItemsSupplier(Suppliers.createEnumSupplier(NotificationType.class, this.AVAILABLE_TYPES::contains));
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return Collections.emptyList();
            }
            return new ArrayList(((ValuesWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            List list = value != null ? (List)value : Collections.emptyList();
            ((ValuesWidget)node).getValues().setAll((Collection)list);
        }

        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    NOTIFICATION_TYPES_TRANSFER{
        private final Set<NotificationType> AVAILABLE_TYPES = EnumSet.of(NotificationType.SERVICES_ISSUED, NotificationType.PAYMENT_REFUND, NotificationType.INTENTION_CANCELLED);

        public Node createNode(boolean readonly) {
            ValuesWidget widget = new ValuesWidget(readonly);
            widget.setItemsSupplier(Suppliers.createEnumSupplier(NotificationType.class, this.AVAILABLE_TYPES::contains));
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return Collections.emptyList();
            }
            return new ArrayList(((ValuesWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            List list = value != null ? (List)value : Collections.emptyList();
            ((ValuesWidget)node).getValues().setAll((Collection)list);
        }

        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    NOTIFICATION_TYPES_ORDER{
        private final Set<NotificationType> AVAILABLE_TYPES = EnumSet.of(NotificationType.ITINERARY_RECEIPT, NotificationType.RECEIPT_LINK);

        public Node createNode(boolean readonly) {
            ValuesWidget widget = new ValuesWidget(readonly);
            widget.setItemsSupplier(Suppliers.createEnumSupplier(NotificationType.class, this.AVAILABLE_TYPES::contains));
            return widget;
        }

        public Object getValue(Node node) {
            if (node == null) {
                return Collections.emptyList();
            }
            return new ArrayList(((ValuesWidget)node).getValues());
        }

        public void setValue(Node node, Object value) {
            if (node == null) {
                return;
            }
            List list = value != null ? (List)value : Collections.emptyList();
            ((ValuesWidget)node).getValues().setAll((Collection)list);
        }

        public boolean isValueEmpty(Node node) {
            return this.getValue(node) == null;
        }
    }
    ,
    HOTEL_GDS_ACCOUNT{

        public Node createNode(boolean readonly) {
            MultiEntityWidget widget = new MultiEntityWidget(BaseGdsAccount.class, readonly);
            widget.setFieldName("\u0410\u043a\u043a\u0430\u0443\u043d\u0442 \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
            widget.setListParametersSupplier(() -> {
                IndexListParameters result = new IndexListParameters();
                result.setIndexType(GdsAccountIndex.class);
                result.getSearchCriterions().add(SearchCriterion.ne((String)GdsAccountIndex.Property.hotelProvider.name(), null));
                ListParametersHelper.setFilters((IndexListParameters)result, (String[])new String[]{GdsAccountIndex.Property.name.name(), GdsAccountIndex.Property.hotelProvider.name(), GdsAccountIndex.Property.agency.name()});
                ListParametersHelper.setColumns((IndexListParameters)result, (String[])new String[]{GdsAccountIndex.Property.name.name(), GdsAccountIndex.Property.hotelProvider.name(), GdsAccountIndex.Property.agency.name()});
                return result;
            });
            return widget;
        }

        public Object getValue(Node node) {
            ArrayList<EntityReference> result = new ArrayList<EntityReference>();
            if (node == null) {
                return result;
            }
            ObservableList list = ((MultiEntityWidget)node).getValues();
            for (EntityReference ref : list) {
                if (result.contains(ref)) continue;
                result.add(ref);
            }
            return result;
        }

        public void setValue(Node node, Object value) {
            List listRef;
            if (node != null && value != null && !(listRef = (List)value).isEmpty()) {
                VMHelper.transfer((Collection)listRef, (Collection)((MultiEntityWidget)node).getValues());
            }
        }

        public boolean isValueEmpty(Node node) {
            return node == null || ((MultiEntityWidget)node).getValues().isEmpty();
        }
    };


    public String getId() {
        return this.name();
    }

    public void buildRestrictionsInfo(Consumer<String> out, RuleRestriction ruleRestriction) {
        RuleProperty property = ruleRestriction.getProperty();
        StringBuilder builder = new StringBuilder();
        property.buildInfo(builder, ruleRestriction.getCondition(), ruleRestriction.getValue());
        out.accept(builder.toString());
    }

    public void setReadonly(boolean readonly, Node node) {
        ((HasViewState)node).getViewState().setReadonly(readonly);
    }
}

