/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.ibecorp.rules;

import com.gridnine.xtrip.client.fx.core.lib.components.tree.CustomCheckBoxTreeView;
import com.gridnine.xtrip.client.fx.core.lib.widgets.NodeRenderer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.PopupWidget;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.ibecorp.l10n.Messages;
import com.gridnine.xtrip.common.ibecorp.rules.SbisExportParametersSettings;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.Introspectable;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.scene.Node;
import javafx.scene.control.TreeItem;
import javafx.scene.layout.BorderPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SbisExportParametersRenderer
implements NodeRenderer {
    public static final SbisExportParametersRenderer instance = new SbisExportParametersRenderer();
    public static final String ROOT_ELM_ID = "ROOT";

    public Node createNode(boolean readonly) {
        PopupWidget popup = new PopupWidget();
        popup.setInfoText(UiUtil.NULL_TEXT);
        SbisExportParametersNode viewNode = new SbisExportParametersNode();
        popup.setView((Node)viewNode);
        popup.setDialogConfigurator(d -> viewNode.updateTree());
        popup.setDialogCloseHandler(() -> popup.setInfoText(this.getInfoText(viewNode)));
        return popup;
    }

    private String getInfoText(SbisExportParametersNode viewNode) {
        int countAllItems;
        int countSelectedItems = viewNode.panel.getSelectedItemsIds().size();
        if (countSelectedItems == (countAllItems = viewNode.panel.getTreeView().getExpandedItemCount() - 1) && countAllItems != 0) {
            return Messages.All;
        }
        if (countSelectedItems > 1 && countSelectedItems < countAllItems) {
            return Messages.Some;
        }
        if (countSelectedItems == 1) {
            return Messages.One;
        }
        return Messages.Not_set;
    }

    public static String getInfoText(SbisExportParametersSettings value) {
        AtomicInteger countSelectItems = new AtomicInteger();
        AtomicInteger countAllIntems = new AtomicInteger();
        if (value != null) {
            EntityType rootEntityType = MetaRegistryHelper.getEntityType((String)SbisExportParametersSettings.class.getName());
            rootEntityType.getProperties().values().forEach(documentType -> {
                Introspectable documentTypeValue = (Introspectable)value.getValue(documentType.getId());
                EntityType documentTypeEntityType = MetaRegistryHelper.getEntityType((String)documentType.getType());
                documentTypeEntityType.getProperties().values().forEach(serviceType -> {
                    Introspectable serviceTypeValue = (Introspectable)documentTypeValue.getValue(serviceType.getId());
                    EntityType serviceTypeEntityType = MetaRegistryHelper.getEntityType((String)serviceType.getType());
                    serviceTypeEntityType.getProperties().values().forEach(serviceTypeProperty -> {
                        if (serviceTypeValue.getValue(serviceTypeProperty.getId()) != null && ((Boolean)serviceTypeValue.getValue(serviceTypeProperty.getId())).booleanValue()) {
                            countSelectItems.getAndIncrement();
                        }
                        countAllIntems.getAndIncrement();
                    });
                });
            });
        }
        if (countSelectItems.get() == countAllIntems.get() && countAllIntems.get() != 0) {
            return Messages.All;
        }
        if (countSelectItems.get() > 1 && countSelectItems.get() < countAllIntems.get()) {
            return Messages.Some;
        }
        if (countSelectItems.get() == 1) {
            return Messages.One;
        }
        return Messages.Not_set;
    }

    public Object getValue(Node node) {
        return ((SbisExportParametersNode)((PopupWidget)node).getView()).getValue();
    }

    public void setValue(Node node, Object value) {
        PopupWidget popup = (PopupWidget)node;
        ((SbisExportParametersNode)popup.getView()).setValue((SbisExportParametersSettings)value);
        popup.setInfoText(SbisExportParametersRenderer.getInfoText((SbisExportParametersSettings)value));
    }

    public void setReadonly(boolean readonly, Node node) {
        ((SbisExportParametersNode)((PopupWidget)node).getView()).setReadonly(readonly);
    }

    private static String createCompaundID(String documentID, String serviceID, String parameterID) {
        return String.format("%s|%s|%s", documentID, serviceID, parameterID);
    }

    static class SbisExportTreeNode {
        private String title;
        private final List<SbisExportTreeNode> children = new ArrayList<SbisExportTreeNode>();
        private String documentID;
        private String serviceID;
        private String parameterID;

        SbisExportTreeNode() {
        }

        String getDocumentID() {
            return this.documentID;
        }

        void setDocumentID(String documentID) {
            this.documentID = documentID;
        }

        String getServiceID() {
            return this.serviceID;
        }

        void setServiceID(String serviceID) {
            this.serviceID = serviceID;
        }

        String getParameterID() {
            return this.parameterID;
        }

        void setParameterID(String parameterID) {
            this.parameterID = parameterID;
        }

        String getTitle() {
            return this.title;
        }

        void setTitle(String title) {
            this.title = title;
        }

        List<SbisExportTreeNode> getChildren() {
            return this.children;
        }

        String getCompaundID() {
            return SbisExportParametersRenderer.createCompaundID(this.documentID, this.serviceID, this.parameterID);
        }
    }

    static class SbisExportParametersTree
    extends CustomCheckBoxTreeView<SbisExportTreeNode> {
        public SbisExportParametersTree(SbisExportTreeNode root) {
            super((Object)root, true, Collections.emptyList());
            UiUtil.expand((TreeItem)this.getTreeView().getRoot());
        }

        protected List<SbisExportTreeNode> getNodeChildren(SbisExportTreeNode reportTreeNode) {
            return reportTreeNode.children;
        }

        protected String getNodeTitle(SbisExportTreeNode reportTreeNode) {
            return reportTreeNode.title;
        }

        protected String getNodeId(SbisExportTreeNode reportTreeNode) {
            return reportTreeNode.getCompaundID();
        }

        protected Comparator<TreeItem<SbisExportTreeNode>> getComparator() {
            return Comparator.comparing(it -> {
                SbisExportTreeNode root = (SbisExportTreeNode)this.getTreeView().getRoot().getValue();
                int idx = root.getChildren().indexOf(it.getValue());
                if (idx != -1) {
                    return idx + "";
                }
                return ((SbisExportTreeNode)it.getValue()).getTitle();
            });
        }
    }

    static class SbisExportParametersNode
    extends BorderPane {
        private final Logger log = LoggerFactory.getLogger(SbisExportParametersNode.class);
        private SbisExportParametersSettings value = null;
        private Boolean readonly;
        private SbisExportParametersTree panel;
        private boolean initialized = false;
        AtomicInteger countProperties = new AtomicInteger();

        SbisExportParametersNode() {
        }

        public void setReadonly(boolean readonly) {
            this.readonly = readonly;
            this.updateTree();
        }

        void setValue(SbisExportParametersSettings value) {
            SbisExportParametersSettings sbisExportParametersSettings = new SbisExportParametersSettings();
            if (value != null) {
                try {
                    XCloneModelHelper.copy((BaseEntity)value, (BaseEntity)sbisExportParametersSettings);
                }
                catch (Exception e) {
                    this.log.error(value.toString(), (Throwable)e);
                }
            }
            this.value = value == null ? sbisExportParametersSettings : sbisExportParametersSettings;
            this.updateTree();
        }

        SbisExportParametersSettings getValue() {
            List selectedItemsIds = this.panel.getSelectedItemsIds();
            EntityType rootEntityType = MetaRegistryHelper.getEntityType((String)SbisExportParametersSettings.class.getName());
            rootEntityType.getProperties().values().forEach(documentType -> {
                Introspectable documentTypeValue = (Introspectable)this.value.getValue(documentType.getId());
                EntityType documentTypeEntityType = MetaRegistryHelper.getEntityType((String)documentType.getType());
                documentTypeEntityType.getProperties().values().forEach(serviceType -> {
                    Introspectable serviceTypeValue = (Introspectable)documentTypeValue.getValue(serviceType.getId());
                    EntityType serviceTypeEntityType = MetaRegistryHelper.getEntityType((String)serviceType.getType());
                    serviceTypeEntityType.getProperties().values().forEach(serviceTypeProperty -> serviceTypeValue.setValue(serviceTypeProperty.getId(), (Object)selectedItemsIds.contains(SbisExportParametersRenderer.createCompaundID(documentType.getId(), serviceType.getId(), serviceTypeProperty.getId()))));
                });
            });
            return this.value;
        }

        private void updateTree() {
            if (!this.initialized && this.value != null && this.readonly != null) {
                SbisExportTreeNode root = new SbisExportTreeNode();
                root.setParameterID(SbisExportParametersRenderer.ROOT_ELM_ID);
                root.setTitle(Messages.Export_parameter);
                ArrayList selectedUids = new ArrayList();
                EntityType rootEntityType = MetaRegistryHelper.getEntityType((String)SbisExportParametersSettings.class.getName());
                rootEntityType.getProperties().values().forEach(documentType -> {
                    SbisExportTreeNode documentTypeNode = new SbisExportTreeNode();
                    documentTypeNode.setDocumentID(documentType.getId());
                    documentTypeNode.setTitle(MetaRegistryHelper.getDisplayName(SbisExportParametersSettings.class, (String)documentType.getId()));
                    root.getChildren().add(documentTypeNode);
                    Introspectable documentTypeValue = (Introspectable)this.value.getValue(documentType.getId());
                    EntityType documentTypeEntityType = MetaRegistryHelper.getEntityType((String)documentType.getType());
                    documentTypeEntityType.getProperties().values().forEach(serviceType -> {
                        SbisExportTreeNode serviceTypeNode = new SbisExportTreeNode();
                        serviceTypeNode.setDocumentID(documentType.getId());
                        serviceTypeNode.setTitle(MetaRegistryHelper.getDisplayName(documentTypeValue.getClass(), (String)serviceType.getId()));
                        serviceTypeNode.setServiceID(serviceType.getId());
                        documentTypeNode.getChildren().add(serviceTypeNode);
                        Introspectable serviceTypeValue = (Introspectable)documentTypeValue.getValue(serviceType.getId());
                        EntityType serviceTypeEntityType = MetaRegistryHelper.getEntityType((String)serviceType.getType());
                        serviceTypeEntityType.getProperties().values().forEach(serviceTypeProperty -> {
                            SbisExportTreeNode propertyNode = new SbisExportTreeNode();
                            propertyNode.setDocumentID(documentType.getId());
                            propertyNode.setServiceID(serviceType.getId());
                            propertyNode.setParameterID(serviceTypeProperty.getId());
                            propertyNode.setTitle(MetaRegistryHelper.getDisplayName(serviceTypeValue.getClass(), (String)serviceTypeProperty.getId()));
                            serviceTypeNode.getChildren().add(propertyNode);
                            Boolean value = (Boolean)serviceTypeValue.getValue(serviceTypeProperty.getId());
                            if (Boolean.TRUE.equals(value)) {
                                selectedUids.add(propertyNode.getCompaundID());
                            }
                            this.countProperties.getAndIncrement();
                        });
                    });
                });
                FxUtil.submitToFxThread(() -> {
                    this.panel = new SbisExportParametersTree(root);
                    this.panel.setReadonly(this.readonly);
                    this.panel.setNodesSelection(selectedUids);
                    if (selectedUids.contains(SbisExportParametersRenderer.ROOT_ELM_ID)) {
                        this.panel.setRootSelected(true);
                    }
                    this.setCenter((Node)this.panel.getTreePane());
                });
                this.initialized = true;
            }
        }
    }
}

