/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.statistic.helpers;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicket;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.carrental.CarRentalProduct;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccident;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristic;
import com.gridnine.xtrip.common.model.booking.railway.RailwayCrimeaMco;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.booking.visa.VisaProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.profile.CalculatedStatisticType;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayCrimeaMcoHelper;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;

public class CommonStatisticsHelper {
    public static void fillFlightDuration(Product product) {
        if (product == null || !CommonStatisticsHelper.isCalculatedStatisticRequired((BaseProduct)product, CalculatedStatisticType.FLIGHT_DURATION)) {
            return;
        }
        int duration = 0;
        for (SegmentTariff st : product.getSegmentTariffs()) {
            for (Segment s : st.getSegments()) {
                if (s.getFlightDuration() == null) continue;
                duration += s.getFlightDuration().intValue();
            }
        }
        if (product.getStatisticalData() == null) {
            product.setStatisticalData(new StatisticalData());
        }
        product.getStatisticalData().setFlightDuration(Integer.valueOf(duration));
    }

    public static void fillSalesDeeps(BookingFile bookingFile) {
        if (bookingFile == null) {
            return;
        }
        bookingFile.getReservations().stream().map(Reservation::getProducts).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).filter(bp -> CommonStatisticsHelper.isCalculatedStatisticRequired(bp, CalculatedStatisticType.SALES_DEEPS)).forEach(CommonStatisticsHelper::fillSalesDeeps);
    }

    private static void fillSalesDeeps(BaseProduct product) {
        if (product instanceof Product) {
            Product prod = (Product)product;
            if (!prod.getSegmentTariffs().isEmpty()) {
                CommonStatisticsHelper.setStatisticalData(prod.getStatisticalData(), CommonStatisticsHelper.getSalesDeeps(prod.getReservation().getResDate(), AirProductHelper.getFirstDepartureDate((Product)prod)));
            }
        } else if (product instanceof RailwayProduct) {
            RailwayProduct prod = (RailwayProduct)product;
            if (!prod.getSegments().isEmpty()) {
                CommonStatisticsHelper.setStatisticalData(prod.getStatisticalData(), CommonStatisticsHelper.getSalesDeeps(prod.getReservation().getResDate(), RailwayProductHelper.getFirstDepartureDate((RailwayProduct)prod)));
            }
        } else if (product instanceof RailwayCrimeaMco) {
            RailwayCrimeaMco prod = (RailwayCrimeaMco)product;
            if (!prod.getSegments().isEmpty()) {
                CommonStatisticsHelper.setStatisticalData(prod.getStatisticalData(), CommonStatisticsHelper.getSalesDeeps(prod.getReservation().getResDate(), RailwayCrimeaMcoHelper.getFirstDepartureDate((RailwayCrimeaMco)prod)));
            }
        } else if (product instanceof CarRentalProduct) {
            CarRentalProduct prod = (CarRentalProduct)product;
            CommonStatisticsHelper.setStatisticalData(prod.getStatisticalData(), CommonStatisticsHelper.getSalesDeeps(prod.getReservation().getResDate(), prod.getStartDate()));
        } else if (product instanceof AeroexpressTicket) {
            AeroexpressTicket prod = (AeroexpressTicket)product;
            CommonStatisticsHelper.setStatisticalData(prod.getStatisticalData(), CommonStatisticsHelper.getSalesDeeps(prod.getReservation().getResDate(), prod.getDepartureDate()));
        } else if (product instanceof VisaProduct) {
            VisaProduct prod = (VisaProduct)product;
            CommonStatisticsHelper.setStatisticalData(prod.getStatisticalData(), CommonStatisticsHelper.getSalesDeeps(prod.getReservation().getResDate(), prod.getStartDate()));
        } else if (product instanceof Transfer) {
            Transfer prod = (Transfer)product;
            CommonStatisticsHelper.setStatisticalData(prod.getStatisticalData(), CommonStatisticsHelper.getSalesDeeps(prod.getReservation().getResDate(), prod.getStartDate()));
        } else if (product instanceof HotelProduct) {
            HotelProduct prod = (HotelProduct)product;
            CommonStatisticsHelper.setStatisticalData(prod.getStatisticalData(), CommonStatisticsHelper.getSalesDeeps(prod.getReservation().getResDate(), !prod.getRooms().isEmpty() ? ((Room)prod.getRooms().get(0)).getCheckInDate() : null));
        } else if (product instanceof InsuranceAccident) {
            InsuranceAccident prod = (InsuranceAccident)product;
            CommonStatisticsHelper.setStatisticalData(prod.getStatisticalData(), CommonStatisticsHelper.getSalesDeeps(prod.getReservation().getResDate(), prod.getDepartureDate()));
        } else if (product instanceof InsuranceTouristic) {
            InsuranceTouristic prod = (InsuranceTouristic)product;
            CommonStatisticsHelper.setStatisticalData(prod.getStatisticalData(), CommonStatisticsHelper.getSalesDeeps(prod.getReservation().getResDate(), prod.getStartDate()));
        }
    }

    private static int getSalesDeeps(Date reservation, Date firstDeparture) {
        if (reservation != null && firstDeparture != null) {
            return (int)MiscUtil.getDaysBetween((Date)reservation, (Date)firstDeparture);
        }
        return 0;
    }

    private static StatisticalData setStatisticalData(StatisticalData data, int deeps) {
        if (data == null) {
            data = new StatisticalData();
        }
        data.setSalesDeeps(Integer.valueOf(deeps));
        return data;
    }

    public static boolean isCalculatedStatisticRequired(EntityReference<Organization> organizationRef, CalculatedStatisticType statisticType) {
        EntityContainer ctr = EntityStorage.get().resolve(organizationRef);
        return ctr != null && ((Organization)ctr.getEntity()).getCalculatedStatisticSettings().contains(statisticType);
    }

    public static boolean isCalculatedStatisticRequired(BaseProduct product, CalculatedStatisticType statisticType) {
        return CommonStatisticsHelper.isCalculatedStatisticRequired((EntityReference<Organization>)product.getReservation().getBookingFile().getCustomerProfile(), statisticType);
    }
}

