/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.parsers.helpers;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.parsers.helpers.ContractSearchContext;
import com.gridnine.xtrip.common.parsers.helpers.ContractSearchResult;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collections;
import java.util.List;

public class ContractParserHelper {
    public static ContractSearchResult searchContract(ContractSearchContext searchContext) throws Exception {
        List contractIndexes = Collections.emptyList();
        if (!TextUtil.isBlank((String)searchContext.getNumber()) && searchContext.getContractType() != null) {
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.number.name(), (Object)searchContext.getNumber()));
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.contractType.name(), (Object)searchContext.getContractType()));
            if (searchContext.getVendor() != null) {
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.vendor.name(), searchContext.getVendor()));
            }
            if (searchContext.getSupplier() != null) {
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.supplier.name(), searchContext.getSupplier()));
            }
            if (searchContext.getCustomer() != null) {
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.customer.name(), searchContext.getCustomer()));
            }
            contractIndexes = EntityStorage.get().search(ContractIndex.class, query).getData();
        }
        if (contractIndexes.size() > 0) {
            ContractSearchResult searchResult = new ContractSearchResult();
            searchResult.setContract((EntityContainer<Contract>)EntityStorage.get().resolve(((ContractIndex)contractIndexes.get(0)).getSource()));
            searchResult.setExists(true);
            searchResult.setUnique(contractIndexes.size() == 1);
            return searchResult;
        }
        Contract contract = new Contract();
        EntityContainer contractContainer = EntityContainer.create((BaseEntity)contract);
        ContractSearchResult searchResult = new ContractSearchResult();
        searchResult.setContract((EntityContainer<Contract>)contractContainer);
        searchResult.setExists(false);
        searchResult.setUnique(true);
        return searchResult;
    }
}

