/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.parsers.helpers;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.parsers.helpers.ProductParserHelper;
import com.gridnine.xtrip.common.parsers.helpers.ProductSearchContext;
import com.gridnine.xtrip.common.parsers.helpers.ProductSearchResult;
import java.util.Date;

public class HotelProductParserHelper {
    private static final int PNR_DAYS_THRESHOLD = 365;
    public static final ProductParserHelper.ProductParserHandler<HotelProduct> handler = new ProductParserHelper.ProductParserHandler<HotelProduct>(){

        @Override
        public HotelProduct createProduct() {
            return new HotelProduct();
        }

        @Override
        public int getThreshold() {
            return 365;
        }

        @Override
        public void setSystemNumber(HotelProduct product, String systemNumber) {
            product.setSystemNumber(systemNumber);
        }

        @Override
        public void setIssueDate(HotelProduct product, Date issueDate) {
            product.setIssueDate(issueDate);
        }

        @Override
        public void setStatus(HotelProduct product, ProductStatus status) {
            product.setStatus(status);
        }

        @Override
        public void setTicketType(HotelProduct product, TicketType ticketType) {
            product.setTicketType(ticketType);
        }

        @Override
        public void setProductCategory(HotelProduct product, ProductCategory productCategory) {
        }

        @Override
        public void setBlankOwner(HotelProduct product, EntityReference<Organization> blankOwner) {
            product.setBlankOwnerRef(blankOwner);
        }

        @Override
        public void setSupplier(HotelProduct product, EntityReference<Organization> supplier) {
            HotelProductHelper.setSupplier((HotelProduct)product, supplier);
        }

        @Override
        public void setAgency(HotelProduct product, EntityReference<Organization> agency) {
            HotelProductHelper.setAgency((HotelProduct)product, agency);
        }

        @Override
        public void setSubagency(HotelProduct product, EntityReference<Organization> subagency) {
            HotelProductHelper.setSubagency((HotelProduct)product, subagency);
        }

        @Override
        public void setPreviousProduct(HotelProduct product, HotelProduct previousProduct) {
            product.setPreviousProduct(previousProduct);
        }

        @Override
        public void setNextProduct(HotelProduct product, HotelProduct nextProduct) {
            product.setNextProduct(nextProduct);
        }

        @Override
        public void addRelatedProduct(HotelProduct product, BaseProduct relatedProduct) {
        }
    };

    public static ProductSearchResult searchProductSell(ProductSearchContext context) throws Exception {
        return ProductParserHelper.searchProductSell(context, handler);
    }

    public static ProductSearchResult searchProductRefund(ProductSearchContext context) throws Exception {
        return ProductParserHelper.searchProductRefund(context, handler);
    }

    public static ProductSearchResult searchProductVoid(ProductSearchContext context) throws Exception {
        return ProductParserHelper.searchProductVoid(context, handler);
    }

    public static ProductSearchContext.ProductCreateResult createProduct(ProductStatus status, String systemNumber) {
        return ProductParserHelper.createProduct(status, systemNumber, null, handler);
    }
}

